/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderFacetComparator;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionLinkFactory;
import org.apache.wicket.Session;

public final class EntityActionUtil {
    private static final MemberOrderFacetComparator memberOrderFacetComparator = new MemberOrderFacetComparator(false);

    private EntityActionUtil() {
    }

    public static List<LinkAndLabel> getEntityActionLinksForAssociation(ScalarModel scalarModel, DeploymentType deploymentType) {
        ArrayList entityActions = Lists.newArrayList();
        if (scalarModel.getKind() != ScalarModel.Kind.PROPERTY) {
            return entityActions;
        }
        ObjectAdapterMemento parentMemento = scalarModel.getParentObjectAdapterMemento();
        EntityModel parentEntityModel = new EntityModel(parentMemento);
        OneToOneAssociation oneToOneAssociation = scalarModel.getPropertyMemento().getProperty();
        List<ObjectAction> associatedActions = EntityActionUtil.getObjectActionsForAssociation(parentEntityModel, (ObjectAssociation)oneToOneAssociation, deploymentType);
        entityActions.addAll(EntityActionUtil.asLinkAndLabelsForAdditionalLinksPanel(parentEntityModel, associatedActions));
        return entityActions;
    }

    public static List<ObjectAction> getObjectActionsForAssociation(EntityModel entityModel, ObjectAssociation association, DeploymentType deploymentType) {
        ArrayList associatedActions = Lists.newArrayList();
        EntityActionUtil.addActions(ActionType.USER, entityModel, association, associatedActions);
        if (deploymentType.isPrototyping()) {
            EntityActionUtil.addActions(ActionType.EXPLORATION, entityModel, association, associatedActions);
            EntityActionUtil.addActions(ActionType.PROTOTYPE, entityModel, association, associatedActions);
        }
        Collections.sort(associatedActions, new Comparator<ObjectAction>(){

            @Override
            public int compare(ObjectAction o1, ObjectAction o2) {
                MemberOrderFacet m1 = (MemberOrderFacet)o1.getFacet(MemberOrderFacet.class);
                MemberOrderFacet m2 = (MemberOrderFacet)o2.getFacet(MemberOrderFacet.class);
                return memberOrderFacetComparator.compare(m1, m2);
            }
        });
        return associatedActions;
    }

    public static List<LinkAndLabel> asLinkAndLabelsForAdditionalLinksPanel(EntityModel entityModel, List<ObjectAction> actions) {
        String linkId = "additionalLink";
        final EntityActionLinkFactory linkFactory = new EntityActionLinkFactory(entityModel);
        final ObjectAdapterMemento adapterMemento = entityModel.getObjectAdapterMemento();
        return Lists.transform(actions, (Function)new Function<ObjectAction, LinkAndLabel>(){

            public LinkAndLabel apply(ObjectAction objectAction) {
                return linkFactory.newLink(adapterMemento, objectAction, "additionalLink");
            }
        });
    }

    private static List<ObjectAction> addActions(ActionType type, EntityModel entityModel, ObjectAssociation association, List<ObjectAction> associatedActions) {
        ObjectSpecification adapterSpec = entityModel.getTypeOfSpecification();
        ObjectAdapter adapter = entityModel.load(AdapterManager.ConcurrencyChecking.NO_CHECK);
        AuthenticationSessionProvider asa = (AuthenticationSessionProvider)Session.get();
        AuthenticationSession authSession = asa.getAuthenticationSession();
        ObjectSpecification objectSpecification = entityModel.getTypeOfSpecification();
        Filter filter = Filters.and((Filter[])new Filter[]{ObjectAction.Filters.memberOrderOf((ObjectAssociation)association), ObjectAction.Filters.dynamicallyVisible((AuthenticationSession)authSession, (ObjectAdapter)adapter, (Where)Where.ANYWHERE), ObjectAction.Filters.notBulkOnly(), ObjectAction.Filters.excludeWizardActions((ObjectSpecification)objectSpecification)});
        List userActions = adapterSpec.getObjectActions(type, Contributed.INCLUDED, filter);
        associatedActions.addAll(userActions);
        return userActions;
    }

    public static void addTopLevelActions(ObjectAdapter adapter, ActionType actionType, List<ObjectAction> topLevelActions, AuthenticationSession authenticationSession) {
        ObjectSpecification adapterSpec = adapter.getSpecification();
        Filter filter = Filters.and((Filter[])new Filter[]{ObjectAction.Filters.memberOrderNotAssociationOf((ObjectSpecification)adapterSpec), ObjectAction.Filters.dynamicallyVisible((AuthenticationSession)authenticationSession, (ObjectAdapter)adapter, (Where)Where.ANYWHERE), ObjectAction.Filters.notBulkOnly(), ObjectAction.Filters.excludeWizardActions((ObjectSpecification)adapterSpec)});
        List userActions = adapterSpec.getObjectActions(actionType, Contributed.INCLUDED, filter);
        topLevelActions.addAll(userActions);
    }

    public static List<ObjectAction> getTopLevelActions(ObjectAdapter adapter, DeploymentType deploymentType, AuthenticationSession authenticationSession) {
        ArrayList topLevelActions = Lists.newArrayList();
        EntityActionUtil.addTopLevelActions(adapter, ActionType.USER, topLevelActions, authenticationSession);
        if (deploymentType.isPrototyping()) {
            EntityActionUtil.addTopLevelActions(adapter, ActionType.EXPLORATION, topLevelActions, authenticationSession);
            EntityActionUtil.addTopLevelActions(adapter, ActionType.PROTOTYPE, topLevelActions, authenticationSession);
        }
        return topLevelActions;
    }
}

