/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.DeploymentQueryImpl;
import org.activiti.engine.impl.ModelQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.DeploymentEntityManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.DeploymentDataManager;
import org.activiti.engine.impl.util.CollectionUtil;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.TimerUtil;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;

public class DeploymentEntityManagerImpl
extends AbstractEntityManager<DeploymentEntity>
implements DeploymentEntityManager {
    protected DeploymentDataManager deploymentDataManager;

    public DeploymentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, DeploymentDataManager deploymentDataManager) {
        super(processEngineConfiguration);
        this.deploymentDataManager = deploymentDataManager;
    }

    @Override
    protected DataManager<DeploymentEntity> getDataManager() {
        return this.deploymentDataManager;
    }

    @Override
    public void insert(DeploymentEntity deployment) {
        this.insert(deployment, false);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert(resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade) {
        List<ProcessDefinition> processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
        this.updateRelatedModels(deploymentId);
        if (cascade) {
            this.deleteProcessInstancesForProcessDefinitions(processDefinitions);
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.deleteProcessDefinitionIdentityLinks(processDefinition);
            this.deleteEventSubscriptions(processDefinition);
            this.deleteProcessDefinitionInfo(processDefinition.getId());
            this.removeTimerStartJobs(processDefinition);
            this.restorePreviousStartEventsIfNeeded(processDefinition);
        }
        this.deleteProcessDefinitionForDeployment(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId), false);
    }

    protected void updateRelatedModels(String deploymentId) {
        List models = new ModelQueryImpl().deploymentId(deploymentId).list();
        for (Model model : models) {
            ModelEntity modelEntity = (ModelEntity)model;
            modelEntity.setDeploymentId(null);
            this.getModelEntityManager().updateModel(modelEntity);
        }
    }

    protected void deleteProcessDefinitionIdentityLinks(ProcessDefinition processDefinition) {
        this.getIdentityLinkEntityManager().deleteIdentityLinksByProcDef(processDefinition.getId());
    }

    protected void deleteEventSubscriptions(ProcessDefinition processDefinition) {
        EventSubscriptionEntityManager eventSubscriptionEntityManager = this.getEventSubscriptionEntityManager();
        eventSubscriptionEntityManager.deleteEventSubscriptionsForProcessDefinition(processDefinition.getId());
    }

    protected void deleteProcessDefinitionInfo(String processDefinitionId) {
        this.getProcessDefinitionInfoEntityManager().deleteProcessDefinitionInfo(processDefinitionId);
    }

    protected void deleteProcessDefinitionForDeployment(String deploymentId) {
        this.getProcessDefinitionEntityManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
    }

    protected void deleteProcessInstancesForProcessDefinitions(List<ProcessDefinition> processDefinitions) {
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.getExecutionEntityManager().deleteProcessInstancesByProcessDefinition(processDefinition.getId(), "deleted deployment", true);
        }
    }

    protected void removeRelatedJobs(ProcessDefinition processDefinition) {
        List<JobEntity> timerJobs = this.getJobEntityManager().findJobsByProcessDefinitionId(processDefinition.getId());
        if (timerJobs != null && timerJobs.size() > 0) {
            for (JobEntity timerJob : timerJobs) {
                if (this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timerJob, null, null, processDefinition.getId()));
                }
                this.getJobEntityManager().delete(timerJob);
            }
        }
    }

    protected void removeTimerSuspendProcesDefJobs(ProcessDefinition processDefinition) {
        List<JobEntity> timerJobs = this.getJobEntityManager().findJobsByTypeAndProcessDefinitionId("suspend-processdefinition", processDefinition.getId());
        if (timerJobs != null && timerJobs.size() > 0) {
            for (JobEntity timerJob : timerJobs) {
                if (this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timerJob, null, null, processDefinition.getId()));
                }
                this.getJobEntityManager().delete(timerJob);
            }
        }
    }

    protected void removeTimerStartJobs(ProcessDefinition processDefinition) {
        List<TimerJobEntity> timerStartJobs = this.getTimerJobEntityManager().findJobsByTypeAndProcessDefinitionId("timer-start-event", processDefinition.getId());
        if (timerStartJobs != null && timerStartJobs.size() > 0) {
            for (TimerJobEntity timerStartJob : timerStartJobs) {
                if (this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timerStartJob, null, null, processDefinition.getId()));
                }
                this.getTimerJobEntityManager().delete(timerStartJob);
            }
        }
    }

    protected void restorePreviousStartEventsIfNeeded(ProcessDefinition processDefinition) {
        ProcessDefinition previousProcessDefinition;
        ProcessDefinitionEntity latestProcessDefinition = this.findLatestProcessDefinition(processDefinition);
        if (processDefinition.getId().equals(latestProcessDefinition.getId()) && (previousProcessDefinition = this.findNewLatestProcessDefinitionAfterRemovalOf(processDefinition)) != null) {
            List startEvents;
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(previousProcessDefinition.getId());
            Process previousProcess = ProcessDefinitionUtil.getProcess(previousProcessDefinition.getId());
            if (CollectionUtil.isNotEmpty(previousProcess.getFlowElements()) && CollectionUtil.isNotEmpty(startEvents = previousProcess.findFlowElementsOfType(StartEvent.class))) {
                for (StartEvent startEvent : startEvents) {
                    if (!CollectionUtil.isNotEmpty(startEvent.getEventDefinitions())) continue;
                    EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
                    if (eventDefinition instanceof TimerEventDefinition) {
                        this.restoreTimerStartEvent(previousProcessDefinition, startEvent, eventDefinition);
                        continue;
                    }
                    if (eventDefinition instanceof SignalEventDefinition) {
                        this.restoreSignalStartEvent(previousProcessDefinition, bpmnModel, startEvent, eventDefinition);
                        continue;
                    }
                    if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                    this.restoreMessageStartEvent(previousProcessDefinition, bpmnModel, startEvent, eventDefinition);
                }
            }
        }
    }

    protected void restoreTimerStartEvent(ProcessDefinition previousProcessDefinition, StartEvent startEvent, EventDefinition eventDefinition) {
        TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
        TimerJobEntity timer = TimerUtil.createTimerEntityForTimerEventDefinition((TimerEventDefinition)eventDefinition, false, null, "timer-start-event", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()));
        if (timer != null) {
            TimerJobEntity timerJob = this.getJobManager().createTimerJob((TimerEventDefinition)eventDefinition, false, null, "timer-start-event", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()));
            timerJob.setProcessDefinitionId(previousProcessDefinition.getId());
            if (previousProcessDefinition.getTenantId() != null) {
                timerJob.setTenantId(previousProcessDefinition.getTenantId());
            }
            this.getJobManager().scheduleTimerJob(timerJob);
        }
    }

    protected void restoreSignalStartEvent(ProcessDefinition previousProcessDefinition, BpmnModel bpmnModel, StartEvent startEvent, EventDefinition eventDefinition) {
        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
        SignalEventSubscriptionEntity subscriptionEntity = this.getEventSubscriptionEntityManager().createSignalEventSubscription();
        Signal signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
        if (signal != null) {
            subscriptionEntity.setEventName(signal.getName());
        } else {
            subscriptionEntity.setEventName(signalEventDefinition.getSignalRef());
        }
        subscriptionEntity.setActivityId(startEvent.getId());
        subscriptionEntity.setProcessDefinitionId(previousProcessDefinition.getId());
        if (previousProcessDefinition.getTenantId() != null) {
            subscriptionEntity.setTenantId(previousProcessDefinition.getTenantId());
        }
        this.getEventSubscriptionEntityManager().insert(subscriptionEntity);
    }

    protected void restoreMessageStartEvent(ProcessDefinition previousProcessDefinition, BpmnModel bpmnModel, StartEvent startEvent, EventDefinition eventDefinition) {
        MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
        if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            Message message = bpmnModel.getMessage(messageEventDefinition.getMessageRef());
            messageEventDefinition.setMessageRef(message.getName());
        }
        MessageEventSubscriptionEntity newSubscription = this.getEventSubscriptionEntityManager().createMessageEventSubscription();
        newSubscription.setEventName(messageEventDefinition.getMessageRef());
        newSubscription.setActivityId(startEvent.getId());
        newSubscription.setConfiguration(previousProcessDefinition.getId());
        newSubscription.setProcessDefinitionId(previousProcessDefinition.getId());
        if (previousProcessDefinition.getTenantId() != null) {
            newSubscription.setTenantId(previousProcessDefinition.getTenantId());
        }
        this.getEventSubscriptionEntityManager().insert(newSubscription);
    }

    protected ProcessDefinitionEntity findLatestProcessDefinition(ProcessDefinition processDefinition) {
        ProcessDefinitionEntity latestProcessDefinition = null;
        latestProcessDefinition = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? this.getProcessDefinitionEntityManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinition.getKey(), processDefinition.getTenantId()) : this.getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(processDefinition.getKey());
        return latestProcessDefinition;
    }

    protected ProcessDefinition findNewLatestProcessDefinitionAfterRemovalOf(ProcessDefinition processDefinitionToBeRemoved) {
        ProcessDefinitionQueryImpl query = new ProcessDefinitionQueryImpl();
        query.processDefinitionKey(processDefinitionToBeRemoved.getKey());
        if (processDefinitionToBeRemoved.getTenantId() != null && !"".equals(processDefinitionToBeRemoved.getTenantId())) {
            query.processDefinitionTenantId(processDefinitionToBeRemoved.getTenantId());
        } else {
            query.processDefinitionWithoutTenantId();
        }
        query.processDefinitionVersionLowerThan(processDefinitionToBeRemoved.getVersion());
        query.orderByProcessDefinitionVersion().desc();
        List<ProcessDefinition> processDefinitions = this.getProcessDefinitionEntityManager().findProcessDefinitionsByQueryCriteria(query, new Page(0, 1));
        if (processDefinitions != null && processDefinitions.size() > 0) {
            return processDefinitions.get(0);
        }
        return null;
    }

    @Override
    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        return this.deploymentDataManager.findLatestDeploymentByName(deploymentName);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return this.deploymentDataManager.findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery, Page page) {
        return this.deploymentDataManager.findDeploymentsByQueryCriteria(deploymentQuery, page);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.deploymentDataManager.getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<Deployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.deploymentDataManager.findDeploymentsByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.deploymentDataManager.findDeploymentCountByNativeQuery(parameterMap);
    }

    public DeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public void setDeploymentDataManager(DeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
    }
}

