/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.CountingExecutionEntity;
import org.activiti.engine.impl.persistence.entity.Entity;
import org.activiti.engine.impl.persistence.entity.EntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.data.DataManager;

public abstract class AbstractEntityManager<EntityImpl extends Entity>
extends AbstractManager
implements EntityManager<EntityImpl> {
    public AbstractEntityManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public EntityImpl findById(String entityId) {
        return this.getDataManager().findById(entityId);
    }

    @Override
    public EntityImpl create() {
        return this.getDataManager().create();
    }

    @Override
    public void insert(EntityImpl entity) {
        this.insert(entity, true);
    }

    @Override
    public void insert(EntityImpl entity, boolean fireCreateEvent) {
        this.getDataManager().insert(entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireCreateEvent && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, entity));
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, entity));
        }
    }

    @Override
    public EntityImpl update(EntityImpl entity) {
        return this.update(entity, true);
    }

    @Override
    public EntityImpl update(EntityImpl entity, boolean fireUpdateEvent) {
        EntityImpl updatedEntity = this.getDataManager().update(entity);
        if (fireUpdateEvent && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, entity));
        }
        return updatedEntity;
    }

    @Override
    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    @Override
    public void delete(EntityImpl entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(EntityImpl entity, boolean fireDeleteEvent) {
        this.getDataManager().delete(entity);
        if (fireDeleteEvent && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, entity));
        }
    }

    protected abstract DataManager<EntityImpl> getDataManager();

    protected boolean isExecutionRelatedEntityCountEnabledGlobally() {
        return this.processEngineConfiguration.getPerformanceSettings().isEnableExecutionRelationshipCounts();
    }

    protected boolean isExecutionRelatedEntityCountEnabled(ExecutionEntity executionEntity) {
        if (executionEntity instanceof CountingExecutionEntity) {
            return this.isExecutionRelatedEntityCountEnabled((CountingExecutionEntity)((Object)executionEntity));
        }
        return false;
    }

    protected boolean isExecutionRelatedEntityCountEnabled(CountingExecutionEntity executionEntity) {
        return this.isExecutionRelatedEntityCountEnabledGlobally() && executionEntity.isCountEnabled();
    }
}

