/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientParser;
import brave.http.HttpSampler;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.propagation.CurrentTraceContext;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import zipkin.Endpoint;
import zipkin2.Endpoint;

public final class HttpClientHandler<Req, Resp> {
    final Tracer tracer;
    final HttpSampler sampler;
    final CurrentTraceContext currentTraceContext;
    final HttpClientParser parser;
    final HttpClientAdapter<Req, Resp> adapter;
    final String serverName;
    final boolean serverNameSet;

    public static <Req, Resp> HttpClientHandler create(HttpTracing httpTracing, HttpClientAdapter<Req, Resp> adapter) {
        return new HttpClientHandler<Req, Resp>(httpTracing, adapter);
    }

    HttpClientHandler(HttpTracing httpTracing, HttpClientAdapter<Req, Resp> adapter) {
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.clientSampler();
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.parser = httpTracing.clientParser();
        this.serverName = httpTracing.serverName();
        this.serverNameSet = !this.serverName.equals("");
        this.adapter = adapter;
    }

    public Span handleSend(TraceContext.Injector<Req> injector, Req request) {
        return this.handleSend(injector, request, request);
    }

    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request) {
        return this.handleSend(injector, carrier, request, this.nextSpan(request));
    }

    public Span handleSend(TraceContext.Injector<Req> injector, Req request, Span span) {
        return this.handleSend(injector, request, request, span);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request, Span span) {
        Endpoint.Builder remoteEndpoint;
        Endpoint.Builder deprecatedEndpoint;
        injector.inject(span.context(), carrier);
        if (span.isNoop()) {
            return span;
        }
        span.kind(Span.Kind.CLIENT);
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.parser.request(this.adapter, request, (SpanCustomizer)span);
        }
        finally {
            ws.close();
        }
        boolean parsedEndpoint = false;
        if (Platform.get().zipkinV1Present() && (parsedEndpoint = this.adapter.parseServerAddress(request, deprecatedEndpoint = zipkin.Endpoint.builder().serviceName(this.serverNameSet ? this.serverName : "")))) {
            span.remoteEndpoint(deprecatedEndpoint.serviceName(this.serverName).build());
        }
        if (!parsedEndpoint && (this.adapter.parseServerAddress(request, remoteEndpoint = Endpoint.newBuilder().serviceName(this.serverName)) || this.serverNameSet)) {
            span.remoteEndpoint(remoteEndpoint.build());
        }
        return span.start();
    }

    public Span nextSpan(Req request) {
        TraceContext parent = this.currentTraceContext.get();
        if (parent != null) {
            return this.tracer.newChild(parent);
        }
        Boolean sampled = this.sampler.trySample(this.adapter, request);
        if (sampled == null) {
            return this.tracer.newTrace();
        }
        return this.tracer.newTrace(sampled != false ? SamplingFlags.SAMPLED : SamplingFlags.NOT_SAMPLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReceive(@Nullable Resp response, @Nullable Throwable error, Span span) {
        if (span.isNoop()) {
            return;
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.parser.response(this.adapter, response, error, (SpanCustomizer)span);
        }
        finally {
            ws.close();
            span.finish();
        }
    }
}

