/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.generic;

import com.google.common.base.Preconditions;
import io.shardingsphere.shardingproxy.transport.mysql.constant.StatusFlag;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import java.beans.ConstructorProperties;

public final class EofPacket
implements MySQLPacket {
    public static final int HEADER = 254;
    private final int sequenceId;
    private final int warnings;
    private final int statusFlags;

    public EofPacket(int sequenceId) {
        this(sequenceId, 0, StatusFlag.SERVER_STATUS_AUTOCOMMIT.getValue());
    }

    public EofPacket(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((254 == payload.readInt1() ? 1 : 0) != 0);
        this.warnings = payload.readInt2();
        this.statusFlags = payload.readInt2();
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(254);
        payload.writeInt2(this.warnings);
        payload.writeInt2(this.statusFlags);
    }

    @ConstructorProperties(value={"sequenceId", "warnings", "statusFlags"})
    public EofPacket(int sequenceId, int warnings, int statusFlags) {
        this.sequenceId = sequenceId;
        this.warnings = warnings;
        this.statusFlags = statusFlags;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public int getStatusFlags() {
        return this.statusFlags;
    }
}

