/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.query;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.backend.ComQueryBackendHandlerFactory;
import io.shardingsphere.shardingproxy.backend.ResultPacket;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.transport.common.packet.DatabasePacket;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacketType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.QueryCommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.TextResultSetRowPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComQueryPacket
implements QueryCommandPacket {
    private static final Logger log = LoggerFactory.getLogger(ComQueryPacket.class);
    private final int sequenceId;
    private final String sql;
    private final BackendHandler backendHandler;

    public ComQueryPacket(int sequenceId, MySQLPacketPayload payload, BackendConnection backendConnection) {
        this.sequenceId = sequenceId;
        this.sql = payload.readStringEOF();
        this.backendHandler = ComQueryBackendHandlerFactory.createBackendHandler(sequenceId, this.sql, backendConnection, DatabaseType.MySQL);
    }

    public ComQueryPacket(int sequenceId, String sql) {
        this.sequenceId = sequenceId;
        this.sql = sql;
        this.backendHandler = null;
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(CommandPacketType.COM_QUERY.getValue());
        payload.writeStringEOF(this.sql);
    }

    @Override
    public Optional<CommandResponsePackets> execute() {
        log.debug("COM_QUERY received for Sharding-Proxy: {}", (Object)this.sql);
        if (GlobalRegistry.getInstance().isCircuitBreak()) {
            return Optional.of((Object)new CommandResponsePackets(new ErrPacket(1, ServerErrorCode.ER_CIRCUIT_BREAK_MODE, new Object[0])));
        }
        return Optional.of((Object)this.backendHandler.execute());
    }

    @Override
    public boolean next() throws SQLException {
        return this.backendHandler.next();
    }

    @Override
    public DatabasePacket getResultValue() throws SQLException {
        ResultPacket resultPacket = this.backendHandler.getResultValue();
        return new TextResultSetRowPacket(resultPacket.getSequenceId(), resultPacket.getData());
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }
}

