/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command;

import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacketType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.admin.UnsupportedCommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.admin.initdb.ComInitDbPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.admin.ping.ComPingPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.admin.quit.ComQuitPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.close.ComStmtClosePacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.ComStmtExecutePacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.prepare.ComStmtPreparePacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.fieldlist.ComFieldListPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.query.ComQueryPacket;
import java.sql.SQLException;

public final class CommandPacketFactory {
    public static CommandPacket newInstance(int sequenceId, MySQLPacketPayload payload, BackendConnection backendConnection) throws SQLException {
        int commandPacketTypeValue = payload.readInt1();
        CommandPacketType type = CommandPacketType.valueOf(commandPacketTypeValue);
        switch (type) {
            case COM_QUIT: {
                return new ComQuitPacket(sequenceId);
            }
            case COM_INIT_DB: {
                return new ComInitDbPacket(sequenceId, payload, backendConnection);
            }
            case COM_FIELD_LIST: {
                return new ComFieldListPacket(sequenceId, payload, backendConnection);
            }
            case COM_QUERY: {
                return new ComQueryPacket(sequenceId, payload, backendConnection);
            }
            case COM_STMT_PREPARE: {
                return new ComStmtPreparePacket(sequenceId, backendConnection, payload);
            }
            case COM_STMT_EXECUTE: {
                return new ComStmtExecutePacket(sequenceId, payload, backendConnection);
            }
            case COM_STMT_CLOSE: {
                return new ComStmtClosePacket(sequenceId, payload);
            }
            case COM_PING: {
                return new ComPingPacket(sequenceId);
            }
        }
        return new UnsupportedCommandPacket(sequenceId, type);
    }

    private CommandPacketFactory() {
    }
}

