/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.runtime;

import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.shardingsphere.api.ConfigMapContext;
import io.shardingsphere.api.config.rule.MasterSlaveRuleConfiguration;
import io.shardingsphere.api.config.rule.RuleConfiguration;
import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import io.shardingsphere.core.constant.properties.ShardingProperties;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.rule.Authentication;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.orchestration.internal.eventbus.ShardingOrchestrationEventBus;
import io.shardingsphere.orchestration.internal.registry.config.event.AuthenticationChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.ConfigMapChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.PropertiesChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.SchemaAddedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.SchemaDeletedEvent;
import io.shardingsphere.orchestration.internal.registry.state.event.CircuitStateChangedEvent;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import io.shardingsphere.shardingproxy.runtime.schema.MasterSlaveSchema;
import io.shardingsphere.shardingproxy.runtime.schema.ShardingSchema;
import io.shardingsphere.shardingproxy.util.DataSourceConverter;
import io.shardingsphere.transaction.api.TransactionType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public final class GlobalRegistry {
    private static final GlobalRegistry INSTANCE = new GlobalRegistry();
    private final EventBus eventBus = ShardingOrchestrationEventBus.getInstance();
    private final Map<String, LogicSchema> logicSchemas = new ConcurrentHashMap<String, LogicSchema>();
    private ShardingProperties shardingProperties = new ShardingProperties(new Properties());
    private Authentication authentication;
    private boolean isCircuitBreak;

    public static GlobalRegistry getInstance() {
        return INSTANCE;
    }

    public void register() {
        this.eventBus.register((Object)this);
    }

    public void init(Map<String, Map<String, DataSourceParameter>> schemaDataSources, Map<String, RuleConfiguration> schemaRules, Authentication authentication, Map<String, Object> configMap, Properties props) {
        this.init(schemaDataSources, schemaRules, authentication, configMap, props, false);
    }

    public void init(Map<String, Map<String, DataSourceParameter>> schemaDataSources, Map<String, RuleConfiguration> schemaRules, Authentication authentication, Map<String, Object> configMap, Properties props, boolean isUsingRegistry) {
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getConfigMap().putAll(configMap);
        }
        if (null != props) {
            this.shardingProperties = new ShardingProperties(props);
        }
        this.authentication = authentication;
        this.initSchema(schemaDataSources, schemaRules, isUsingRegistry);
    }

    private void initSchema(Map<String, Map<String, DataSourceParameter>> schemaDataSources, Map<String, RuleConfiguration> schemaRules, boolean isUsingRegistry) {
        for (Map.Entry<String, RuleConfiguration> entry : schemaRules.entrySet()) {
            String schemaName = entry.getKey();
            this.logicSchemas.put(schemaName, this.createLogicSchema(schemaName, schemaDataSources, entry.getValue(), isUsingRegistry));
        }
    }

    private LogicSchema createLogicSchema(String schemaName, Map<String, Map<String, DataSourceParameter>> schemaDataSources, RuleConfiguration ruleConfiguration, boolean isUsingRegistry) {
        return ruleConfiguration instanceof ShardingRuleConfiguration ? new ShardingSchema(schemaName, schemaDataSources.get(schemaName), (ShardingRuleConfiguration)ruleConfiguration, (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.CHECK_TABLE_METADATA_ENABLED), isUsingRegistry) : new MasterSlaveSchema(schemaName, schemaDataSources.get(schemaName), (MasterSlaveRuleConfiguration)ruleConfiguration, isUsingRegistry);
    }

    public TransactionType getTransactionType() {
        return TransactionType.valueOf((String)((String)this.shardingProperties.getValue(ShardingPropertiesConstant.PROXY_TRANSACTION_TYPE)));
    }

    public boolean schemaExists(String schema) {
        return this.logicSchemas.keySet().contains(schema);
    }

    public LogicSchema getLogicSchema(String schemaName) {
        return Strings.isNullOrEmpty((String)schemaName) ? null : this.logicSchemas.get(schemaName);
    }

    public List<String> getSchemaNames() {
        return new LinkedList<String>(this.logicSchemas.keySet());
    }

    @Subscribe
    public synchronized void renew(PropertiesChangedEvent propertiesChangedEvent) {
        this.shardingProperties = new ShardingProperties(propertiesChangedEvent.getProps());
    }

    @Subscribe
    public synchronized void renew(AuthenticationChangedEvent authenticationChangedEvent) {
        this.authentication = authenticationChangedEvent.getAuthentication();
    }

    @Subscribe
    public synchronized void renew(ConfigMapChangedEvent configMapChangedEvent) {
        ConfigMapContext.getInstance().getConfigMap().clear();
        ConfigMapContext.getInstance().getConfigMap().putAll(configMapChangedEvent.getConfigMap());
    }

    @Subscribe
    public synchronized void renew(CircuitStateChangedEvent circuitStateChangedEvent) {
        this.isCircuitBreak = circuitStateChangedEvent.isCircuitBreak();
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent schemaAddedEvent) {
        this.logicSchemas.put(schemaAddedEvent.getShardingSchemaName(), this.createLogicSchema(schemaAddedEvent.getShardingSchemaName(), Collections.singletonMap(schemaAddedEvent.getShardingSchemaName(), DataSourceConverter.getDataSourceParameterMap(schemaAddedEvent.getDataSourceConfigurations())), schemaAddedEvent.getRuleConfiguration(), true));
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent schemaDeletedEvent) {
        this.logicSchemas.remove(schemaDeletedEvent.getShardingSchemaName());
    }

    private GlobalRegistry() {
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public Map<String, LogicSchema> getLogicSchemas() {
        return this.logicSchemas;
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public boolean isCircuitBreak() {
        return this.isCircuitBreak;
    }
}

