/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.sctl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.shardingproxy.backend.sctl.ShardingCTLParser;
import io.shardingsphere.shardingproxy.backend.sctl.ShardingCTLShowStatement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ShardingCTLShowParser
implements ShardingCTLParser<ShardingCTLShowStatement> {
    private final String regex = "sctl:show\\s+(\\S*)";
    private Matcher matcher;

    ShardingCTLShowParser(String sql) {
        this.matcher = Pattern.compile("sctl:show\\s+(\\S*)", 2).matcher(sql);
    }

    @Override
    public Optional<ShardingCTLShowStatement> doParse() {
        if (this.matcher.find()) {
            String value = this.matcher.group(1);
            Preconditions.checkNotNull((Object)value, (Object)"sctl show value cannot be null.");
            return Optional.of((Object)new ShardingCTLShowStatement(value));
        }
        return Optional.absent();
    }
}

