/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.sctl;

import com.google.common.base.Optional;
import io.shardingsphere.shardingproxy.backend.AbstractBackendHandler;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.backend.sctl.ShardingCTLSetParser;
import io.shardingsphere.shardingproxy.backend.sctl.ShardingCTLSetStatement;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import io.shardingsphere.transaction.api.TransactionType;

public final class ShardingCTLSetBackendHandler
extends AbstractBackendHandler {
    private final String sql;
    private final BackendConnection backendConnection;

    public ShardingCTLSetBackendHandler(String sql, BackendConnection backendConnection) {
        this.sql = sql.toUpperCase().trim();
        this.backendConnection = backendConnection;
    }

    @Override
    protected CommandResponsePackets execute0() {
        Optional<ShardingCTLSetStatement> shardingTCLStatement = new ShardingCTLSetParser(this.sql).doParse();
        if (!shardingTCLStatement.isPresent()) {
            return new CommandResponsePackets(new ErrPacket(" please review your sctl format, should be sctl:set xxx=yyy."));
        }
        switch (((ShardingCTLSetStatement)shardingTCLStatement.get()).getKey()) {
            case "TRANSACTION_TYPE": {
                this.backendConnection.setTransactionType(TransactionType.valueOf((String)((ShardingCTLSetStatement)shardingTCLStatement.get()).getValue()));
                break;
            }
            default: {
                return new CommandResponsePackets(new ErrPacket(String.format(" could not support this sctl grammar [%s].", this.sql)));
            }
        }
        return new CommandResponsePackets(new OKPacket(1));
    }
}

