/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.connection;

import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.ConnectionStatus;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.MethodInvocation;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.TransactionManager;
import io.shardingsphere.transaction.core.TransactionOperationType;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;

public final class LocalTransactionManager
implements TransactionManager {
    private final BackendConnection connection;

    @Override
    public void doInTransaction(TransactionOperationType operationType) throws SQLException {
        switch (operationType) {
            case BEGIN: {
                this.setAutoCommit();
                break;
            }
            case COMMIT: {
                this.commit();
                break;
            }
            case ROLLBACK: {
                this.rollback();
                break;
            }
        }
    }

    private void setAutoCommit() {
        this.recordMethodInvocation(Connection.class, "setAutoCommit", new Class[]{Boolean.TYPE}, new Object[]{false});
    }

    private void commit() throws SQLException {
        if (this.connection.getStateHandler().isInTransaction()) {
            LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
            exceptions.addAll(this.commitConnections());
            this.connection.getStateHandler().getAndSetStatus(ConnectionStatus.TERMINATED);
            this.throwSQLExceptionIfNecessary(exceptions);
        }
    }

    private void rollback() throws SQLException {
        if (this.connection.getStateHandler().isInTransaction()) {
            LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
            exceptions.addAll(this.rollbackConnections());
            this.connection.getStateHandler().getAndSetStatus(ConnectionStatus.TERMINATED);
            this.throwSQLExceptionIfNecessary(exceptions);
        }
    }

    private Collection<SQLException> commitConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                each.commit();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    private Collection<SQLException> rollbackConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                each.rollback();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    private void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        for (SQLException each : exceptions) {
            ex.setNextException(each);
        }
        throw ex;
    }

    private void recordMethodInvocation(Class<?> targetClass, String methodName, Class<?>[] argumentTypes, Object[] arguments) {
        this.connection.getMethodInvocations().add(new MethodInvocation(targetClass.getMethod(methodName, argumentTypes), arguments));
    }

    @ConstructorProperties(value={"connection"})
    public LocalTransactionManager(BackendConnection connection) {
        this.connection = connection;
    }
}

