/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc;

import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.merger.MergeEngineFactory;
import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.dal.show.ShowTablesMergedResult;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.parser.constant.DerivedColumn;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.shardingproxy.backend.AbstractBackendHandler;
import io.shardingsphere.shardingproxy.backend.ResultPacket;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.ConnectionStatus;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.JDBCExecuteEngine;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.response.ExecuteQueryResponse;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.response.ExecuteResponse;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.response.ExecuteUpdateResponse;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import io.shardingsphere.shardingproxy.runtime.schema.ShardingSchema;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.ColumnDefinition41Packet;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.FieldCountPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.QueryResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import io.shardingsphere.transaction.api.TransactionType;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.ArrayList;

public final class JDBCBackendHandler
extends AbstractBackendHandler {
    private final LogicSchema logicSchema;
    private final String sql;
    private final JDBCExecuteEngine executeEngine;
    private ExecuteResponse executeResponse;
    private MergedResult mergedResult;
    private int currentSequenceId;

    @Override
    protected CommandResponsePackets execute0() throws SQLException {
        return this.logicSchema == null ? new CommandResponsePackets(new ErrPacket(1, ServerErrorCode.ER_NO_DB_ERROR, new Object[0])) : this.execute(this.executeEngine.getJdbcExecutorWrapper().route(this.sql, DatabaseType.MySQL));
    }

    private CommandResponsePackets execute(SQLRouteResult routeResult) throws SQLException {
        if (routeResult.getRouteUnits().isEmpty()) {
            return new CommandResponsePackets(new OKPacket(1));
        }
        SQLStatement sqlStatement = routeResult.getSqlStatement();
        if (this.isUnsupportedXA(sqlStatement.getType())) {
            return new CommandResponsePackets(new ErrPacket(1, ServerErrorCode.ER_ERROR_ON_MODIFYING_GTID_EXECUTED_TABLE, sqlStatement.getTables().isSingleTable() ? sqlStatement.getTables().getSingleTableName() : "unknown_table"));
        }
        this.executeResponse = this.executeEngine.execute(routeResult);
        if (this.logicSchema instanceof ShardingSchema) {
            this.refreshTableMetaData(this.logicSchema, routeResult.getSqlStatement());
        }
        return this.merge(sqlStatement);
    }

    private boolean isUnsupportedXA(SQLType sqlType) {
        BackendConnection connection = this.executeEngine.getBackendConnection();
        return TransactionType.XA == connection.getTransactionType() && SQLType.DDL == sqlType && ConnectionStatus.TRANSACTION == connection.getStateHandler().getStatus();
    }

    private CommandResponsePackets merge(SQLStatement sqlStatement) throws SQLException {
        if (this.executeResponse instanceof ExecuteUpdateResponse) {
            return ((ExecuteUpdateResponse)this.executeResponse).merge();
        }
        this.mergedResult = MergeEngineFactory.newInstance((DatabaseType)DatabaseType.MySQL, (ShardingRule)this.getShardingRule(), (SQLStatement)sqlStatement, (ShardingTableMetaData)this.logicSchema.getMetaData().getTable(), ((ExecuteQueryResponse)this.executeResponse).getQueryResults()).merge();
        if (this.mergedResult instanceof ShowTablesMergedResult) {
            ((ShowTablesMergedResult)this.mergedResult).resetColumnLabel(this.logicSchema.getName());
            this.setResponseColumnLabelForShowTablesMergedResult(((ExecuteQueryResponse)this.executeResponse).getQueryResponsePackets());
        }
        QueryResponsePackets result = this.getQueryResponsePacketsWithoutDerivedColumns(((ExecuteQueryResponse)this.executeResponse).getQueryResponsePackets());
        this.currentSequenceId = result.getPackets().size();
        return result;
    }

    private ShardingRule getShardingRule() {
        return this.logicSchema instanceof ShardingSchema ? ((ShardingSchema)this.logicSchema).getShardingRule() : new ShardingRule(new ShardingRuleConfiguration(), this.logicSchema.getDataSources().keySet());
    }

    private QueryResponsePackets getQueryResponsePacketsWithoutDerivedColumns(QueryResponsePackets queryResponsePackets) {
        ArrayList<ColumnDefinition41Packet> columnDefinition41Packets = new ArrayList<ColumnDefinition41Packet>(queryResponsePackets.getColumnCount());
        int columnCount = 0;
        for (ColumnDefinition41Packet each : queryResponsePackets.getColumnDefinition41Packets()) {
            if (DerivedColumn.isDerivedColumn((String)each.getName())) continue;
            columnDefinition41Packets.add(each);
            ++columnCount;
        }
        FieldCountPacket fieldCountPacket = new FieldCountPacket(1, columnCount);
        return new QueryResponsePackets(fieldCountPacket, columnDefinition41Packets, new EofPacket(columnCount + 2));
    }

    private void setResponseColumnLabelForShowTablesMergedResult(QueryResponsePackets queryResponsePackets) {
        for (ColumnDefinition41Packet each : queryResponsePackets.getColumnDefinition41Packets()) {
            if (!each.getName().startsWith("Tables_in_")) continue;
            each.setName("Tables_in_" + this.logicSchema.getName());
            break;
        }
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public ResultPacket getResultValue() throws SQLException {
        QueryResponsePackets queryResponsePackets = ((ExecuteQueryResponse)this.executeResponse).getQueryResponsePackets();
        int columnCount = queryResponsePackets.getColumnCount();
        ArrayList<Object> data = new ArrayList<Object>(columnCount);
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            data.add(this.mergedResult.getValue(columnIndex, Object.class));
        }
        return new ResultPacket(++this.currentSequenceId, data, columnCount, queryResponsePackets.getColumnTypes());
    }

    @ConstructorProperties(value={"logicSchema", "sql", "executeEngine"})
    public JDBCBackendHandler(LogicSchema logicSchema, String sql, JDBCExecuteEngine executeEngine) {
        this.logicSchema = logicSchema;
        this.sql = sql;
        this.executeEngine = executeEngine;
    }
}

