/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend;

import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.UseStatement;
import io.shardingsphere.core.util.SQLUtil;
import io.shardingsphere.shardingproxy.backend.AbstractBackendHandler;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import java.beans.ConstructorProperties;

public final class UseSchemaBackendHandler
extends AbstractBackendHandler {
    private final UseStatement useStatement;
    private final BackendConnection backendConnection;

    @Override
    protected CommandResponsePackets execute0() {
        String schema = SQLUtil.getExactlyValue((String)this.useStatement.getSchema());
        if (!GlobalRegistry.getInstance().schemaExists(schema)) {
            return new CommandResponsePackets(new ErrPacket(1, ServerErrorCode.ER_BAD_DB_ERROR, schema));
        }
        this.backendConnection.setCurrentSchema(schema);
        return new CommandResponsePackets(new OKPacket(1));
    }

    @ConstructorProperties(value={"useStatement", "backendConnection"})
    public UseSchemaBackendHandler(UseStatement useStatement, BackendConnection backendConnection) {
        this.useStatement = useStatement;
        this.backendConnection = backendConnection;
    }
}

