/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend;

import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.dal.show.ShowDatabasesMergedResult;
import io.shardingsphere.shardingproxy.backend.AbstractBackendHandler;
import io.shardingsphere.shardingproxy.backend.ResultPacket;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ColumnType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.ColumnDefinition41Packet;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.FieldCountPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.QueryResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class ShowDatabasesBackendHandler
extends AbstractBackendHandler {
    private MergedResult mergedResult;
    private int currentSequenceId;
    private int columnCount;
    private final List<ColumnType> columnTypes = new LinkedList<ColumnType>();

    @Override
    protected CommandResponsePackets execute0() {
        return this.handleShowDatabasesStatement();
    }

    private CommandResponsePackets handleShowDatabasesStatement() {
        this.mergedResult = new ShowDatabasesMergedResult(GlobalRegistry.getInstance().getSchemaNames());
        int sequenceId = 0;
        FieldCountPacket fieldCountPacket = new FieldCountPacket(++sequenceId, 1);
        ArrayList<ColumnDefinition41Packet> columnDefinition41Packets = new ArrayList<ColumnDefinition41Packet>(1);
        columnDefinition41Packets.add(new ColumnDefinition41Packet(++sequenceId, "", "", "", "Database", "", 100, ColumnType.MYSQL_TYPE_VARCHAR, 0));
        QueryResponsePackets queryResponsePackets = new QueryResponsePackets(fieldCountPacket, columnDefinition41Packets, new EofPacket(++sequenceId));
        this.currentSequenceId = queryResponsePackets.getPackets().size();
        this.columnCount = queryResponsePackets.getColumnCount();
        this.columnTypes.addAll(queryResponsePackets.getColumnTypes());
        return queryResponsePackets;
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public ResultPacket getResultValue() throws SQLException {
        ArrayList<Object> data = new ArrayList<Object>(this.columnCount);
        for (int columnIndex = 1; columnIndex <= this.columnCount; ++columnIndex) {
            data.add(this.mergedResult.getValue(columnIndex, Object.class));
        }
        return new ResultPacket(++this.currentSequenceId, data, this.columnCount, this.columnTypes);
    }
}

