/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.parsing.SQLJudgeEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowDatabasesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.UseStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.set.SetStatement;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.backend.BackendHandlerFactory;
import io.shardingsphere.shardingproxy.backend.SchemaBroadcastBackendHandler;
import io.shardingsphere.shardingproxy.backend.ShowDatabasesBackendHandler;
import io.shardingsphere.shardingproxy.backend.SkipBackendHandler;
import io.shardingsphere.shardingproxy.backend.TransactionBackendHandler;
import io.shardingsphere.shardingproxy.backend.UnicastSchemaBackendHandler;
import io.shardingsphere.shardingproxy.backend.UseSchemaBackendHandler;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.backend.sctl.ShardingCTLSetBackendHandler;
import io.shardingsphere.shardingproxy.backend.sctl.ShardingCTLShowBackendHandler;
import io.shardingsphere.transaction.core.TransactionOperationType;

public class ComQueryBackendHandlerFactory {
    private static final String SCTL_SET = "SCTL:SET";
    private static final String SCTL_SHOW = "SCTL:SHOW";
    private static final String SKIP_SQL = "SET AUTOCOMMIT=1";

    public static BackendHandler createBackendHandler(int sequenceId, String sql, BackendConnection backendConnection, DatabaseType databaseType) {
        Optional transactionOperationType = TransactionOperationType.getOperationType((String)sql.toUpperCase());
        if (transactionOperationType.isPresent()) {
            return new TransactionBackendHandler((TransactionOperationType)transactionOperationType.get(), backendConnection);
        }
        if (sql.toUpperCase().startsWith(SCTL_SET)) {
            return new ShardingCTLSetBackendHandler(sql, backendConnection);
        }
        if (sql.toUpperCase().startsWith(SCTL_SHOW)) {
            return new ShardingCTLShowBackendHandler(sql, backendConnection);
        }
        if (sql.toUpperCase().contains(SKIP_SQL)) {
            return new SkipBackendHandler();
        }
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        if (SQLType.DCL == sqlStatement.getType() || sqlStatement instanceof SetStatement) {
            return new SchemaBroadcastBackendHandler(sequenceId, sql, backendConnection, databaseType, BackendHandlerFactory.getInstance());
        }
        if (sqlStatement instanceof UseStatement) {
            return new UseSchemaBackendHandler((UseStatement)sqlStatement, backendConnection);
        }
        if (sqlStatement instanceof ShowDatabasesStatement) {
            return new ShowDatabasesBackendHandler();
        }
        if (SQLType.DAL == sqlStatement.getType()) {
            return new UnicastSchemaBackendHandler(sequenceId, sql, backendConnection, BackendHandlerFactory.getInstance());
        }
        return BackendHandlerFactory.getInstance().newTextProtocolInstance(sequenceId, sql, backendConnection, DatabaseType.MySQL);
    }
}

