/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.opentracing.hook;

import io.opentracing.ActiveSpan;
import io.opentracing.tag.Tags;
import io.shardingsphere.core.executor.ShardingExecuteDataMap;
import io.shardingsphere.opentracing.ShardingTracer;
import io.shardingsphere.opentracing.constant.ShardingTags;
import io.shardingsphere.spi.root.RootInvokeHook;

public final class OpenTracingRootInvokeHook
implements RootInvokeHook {
    public static final String ACTIVE_SPAN_CONTINUATION = "ACTIVE_SPAN_CONTINUATION";
    private static final String OPERATION_NAME = "/Sharding-Sphere/rootInvoke/";
    private ActiveSpan activeSpan;

    public void start() {
        this.activeSpan = ShardingTracer.get().buildSpan(OPERATION_NAME).withTag(Tags.COMPONENT.getKey(), "Sharding-Sphere").startActive();
        ShardingExecuteDataMap.getDataMap().put(ACTIVE_SPAN_CONTINUATION, this.activeSpan.capture());
    }

    public void finish(int connectionCount) {
        ((ActiveSpan)this.activeSpan.setTag(ShardingTags.CONNECTION_COUNT.getKey(), (Number)connectionCount)).deactivate();
    }
}

