/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.utils;

import io.servicecomb.serviceregistry.utils.TimerException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Timer {
    public static final int DEFAULT_MAX_TIMEOUT = 60;
    public static final int DEFAULT_RETRY_TIMES = 3;
    public static final int DEFAULT_STEP_SIZE = 10;
    private int max = 0;
    private int times = 0;
    private int stepSize = 0;
    private boolean increase = true;
    private AtomicInteger current = new AtomicInteger(0);

    public static Timer newDefaultTimer() {
        return new Timer();
    }

    public static Timer newForeverTimer() {
        return new Timer(0, -1);
    }

    public Timer() {
        this(60, 3, 10, true);
    }

    public Timer(int max) {
        this(max, 3, 10, true);
    }

    public Timer(int max, int times) {
        this(max, times, 10, true);
    }

    public Timer(int max, int times, int stepSize, boolean increase) {
        this.max = max <= 0 ? 60 : max;
        this.times = times;
        this.stepSize = stepSize <= 0 ? 10 : stepSize;
        this.increase = increase;
    }

    public int getMax() {
        return this.max;
    }

    public int getTimes() {
        return this.times;
    }

    public int getCurrent() {
        return this.current.get();
    }

    public int getNextTimeout() {
        if (this.increase) {
            int timeout = (this.current.get() + 1) * this.stepSize;
            return timeout > this.max ? this.max : timeout;
        }
        return this.stepSize > this.max ? this.max : this.stepSize;
    }

    public int nextTimeout() {
        int current = this.current.incrementAndGet();
        if (this.increase) {
            int timeout = current * this.stepSize;
            return timeout > this.max ? this.max : timeout;
        }
        return this.stepSize > this.max ? this.max : this.stepSize;
    }

    public void sleep() throws TimerException {
        if (this.times >= 0 && this.times <= this.current.get()) {
            throw new TimerException();
        }
        try {
            TimeUnit.SECONDS.sleep(this.nextTimeout());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void reset() {
        this.current.set(0);
    }
}

