/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import io.servicecomb.serviceregistry.task.AbstractRegisterTask;
import io.servicecomb.serviceregistry.task.HeartbeatResult;
import io.servicecomb.serviceregistry.task.MicroserviceInstanceHeartbeatTask;
import io.servicecomb.serviceregistry.task.TaskStatus;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MicroserviceRegisterTask
extends AbstractRegisterTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceRegisterTask.class);
    private boolean schemaIdSetMatch;

    public MicroserviceRegisterTask(EventBus eventBus, ServiceRegistryClient srClient, Microservice microservice) {
        super(eventBus, srClient, microservice);
        this.taskStatus = TaskStatus.READY;
    }

    public boolean isSchemaIdSetMatch() {
        return this.schemaIdSetMatch;
    }

    @Subscribe
    public void onMicroserviceInstanceHeartbeatTask(MicroserviceInstanceHeartbeatTask task) {
        if (task.getHeartbeatResult() != HeartbeatResult.SUCCESS && this.isSameMicroservice(task.getMicroservice())) {
            LOGGER.info("read MicroserviceInstanceHeartbeatTask status is {}", (Object)task.taskStatus);
            this.taskStatus = TaskStatus.READY;
            this.registered = false;
        }
    }

    @Override
    protected boolean doRegister() {
        LOGGER.info("running microservice register task.");
        String serviceId = this.srClient.getMicroserviceId(this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion());
        if (!StringUtils.isEmpty((Object)serviceId)) {
            this.microservice.setServiceId(serviceId);
            LOGGER.info("Microservice exists in service center, no need to register. id={} appId={}, name={}, version={}", new Object[]{serviceId, this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion()});
            if (!this.checkSchemaIdSet()) {
                return false;
            }
        } else {
            serviceId = this.srClient.registerMicroservice(this.microservice);
            if (StringUtils.isEmpty((Object)serviceId)) {
                LOGGER.error("Registry microservice failed. appId={}, name={}, version={}", new Object[]{this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion()});
                return false;
            }
            this.schemaIdSetMatch = true;
            this.microservice.getIntance().setInstanceId(null);
            LOGGER.info("Registry Microservice successfully. id={} appId={}, name={}, version={}, schemaIds={}", new Object[]{serviceId, this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion(), this.microservice.getSchemas()});
        }
        this.microservice.setServiceId(serviceId);
        this.microservice.getIntance().setServiceId(this.microservice.getServiceId());
        return this.registerSchemas();
    }

    private boolean checkSchemaIdSet() {
        Microservice existMicroservice = this.srClient.getMicroservice(this.microservice.getServiceId());
        if (existMicroservice == null) {
            LOGGER.error("Error to get microservice from service center when check schema set");
            return false;
        }
        HashSet<String> existSchemas = new HashSet<String>(existMicroservice.getSchemas());
        HashSet<String> localSchemas = new HashSet<String>(this.microservice.getSchemas());
        this.schemaIdSetMatch = existSchemas.equals(localSchemas);
        if (!this.schemaIdSetMatch) {
            LOGGER.error("SchemaIds is different between local and service center. Please change microservice version. id={} appId={}, name={}, version={}, local schemaIds={}, service center schemaIds={}", new Object[]{this.microservice.getServiceId(), this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion(), localSchemas, existSchemas});
            return true;
        }
        LOGGER.info("SchemaIds is equals to service center. id={} appId={}, name={}, version={}, schemaIds={}", new Object[]{this.microservice.getServiceId(), this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion(), localSchemas});
        return true;
    }

    private boolean registerSchemas() {
        for (Map.Entry<String, String> entry : this.microservice.getSchemaMap().entrySet()) {
            String schemaId = entry.getKey();
            String content = entry.getValue();
            boolean exists = this.srClient.isSchemaExist(this.microservice.getServiceId(), schemaId);
            LOGGER.info("schemaId {} exists {}", (Object)schemaId, (Object)exists);
            if (exists || this.srClient.registerSchema(this.microservice.getServiceId(), schemaId, content)) continue;
            return false;
        }
        return true;
    }
}

