/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.task;

import io.servicecomb.serviceregistry.cache.InstanceCache;
import io.servicecomb.serviceregistry.cache.InstanceCacheManagerOld;
import io.servicecomb.serviceregistry.task.ServiceCenterTaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancePullTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstancePullTask.class);
    private ServiceCenterTaskMonitor serviceCenterTaskMonitor = new ServiceCenterTaskMonitor();
    private InstanceCacheManagerOld cacheManager;
    private int interval;

    public InstancePullTask(int interval, InstanceCacheManagerOld cacheManager) {
        this.interval = interval;
        this.cacheManager = cacheManager;
    }

    @Override
    public void run() {
        try {
            this.serviceCenterTaskMonitor.beginCycle(this.interval);
            for (InstanceCache cache : this.cacheManager.getCachedEntries()) {
                InstanceCache newCache = this.cacheManager.createInstanceCache(cache.getAppId(), cache.getMicroserviceName(), cache.getMicroserviceVersionRule());
                if (newCache == null) continue;
                this.cacheManager.updateInstanceMap(cache.getAppId(), cache.getMicroserviceName(), newCache);
            }
            this.serviceCenterTaskMonitor.endCycle();
        }
        catch (Throwable e) {
            LOGGER.error("unexpected exception in instance pull task.", e);
        }
    }
}

