/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import io.servicecomb.serviceregistry.task.TaskStatus;

public abstract class AbstractTask
implements Runnable {
    protected TaskStatus taskStatus = TaskStatus.INIT;
    protected EventBus eventBus;
    protected ServiceRegistryClient srClient;
    protected Microservice microservice;

    public AbstractTask(EventBus eventBus, ServiceRegistryClient srClient, Microservice microservice) {
        this.eventBus = eventBus;
        this.srClient = srClient;
        this.microservice = microservice;
        this.eventBus.register((Object)this);
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public Microservice getMicroservice() {
        return this.microservice;
    }

    @Override
    public void run() {
        if (this.taskStatus == TaskStatus.READY) {
            this.doRun();
            this.eventBus.post((Object)this);
        }
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    protected abstract void doRun();

    protected boolean isSameMicroservice(Microservice otherMicroservice) {
        return this.microservice.getServiceName().equals(otherMicroservice.getServiceName());
    }
}

