/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.discovery;

import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.discovery.DiscoveryContext;
import io.servicecomb.serviceregistry.discovery.DiscoveryFilter;
import io.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEndpointDiscoveryFilter
implements DiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEndpointDiscoveryFilter.class);
    private static final String ALL_TRANSPORT = "";

    @Override
    public boolean isGroupingFilter() {
        return true;
    }

    @Override
    public DiscoveryTreeNode discovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        String expectTransportName = this.findTransportName(context, parent);
        return parent.children().computeIfAbsent(expectTransportName, etn -> this.createDiscoveryTreeNode(expectTransportName, context, parent));
    }

    protected DiscoveryTreeNode createDiscoveryTreeNode(String expectTransportName, DiscoveryContext context, DiscoveryTreeNode parent) {
        ArrayList<Object> endpoints = new ArrayList<Object>();
        for (MicroserviceInstance instance : ((Map)parent.data()).values()) {
            for (String endpoint : instance.getEndpoints()) {
                try {
                    Object objEndpoint;
                    URI uri = URI.create(endpoint);
                    String transportName = uri.getScheme();
                    if (!this.isTransportNameMatch(transportName, expectTransportName) || (objEndpoint = this.createEndpoint(transportName, endpoint, instance)) == null) continue;
                    endpoints.add(objEndpoint);
                }
                catch (Exception e) {
                    LOGGER.warn("unrecognized address find, ignore {}.", (Object)endpoint);
                }
            }
        }
        return (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, expectTransportName).data(endpoints);
    }

    protected boolean isTransportNameMatch(String transportName, String expectTransportName) {
        return ALL_TRANSPORT.equals(expectTransportName) || transportName.equals(expectTransportName);
    }

    protected abstract String findTransportName(DiscoveryContext var1, DiscoveryTreeNode var2);

    protected abstract Object createEndpoint(String var1, String var2, MicroserviceInstance var3);
}

