/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.cache;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.servicecomb.foundation.common.cache.VersionedCache;
import io.servicecomb.serviceregistry.ServiceRegistry;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import io.servicecomb.serviceregistry.cache.InstanceCache;
import io.servicecomb.serviceregistry.cache.InstanceCacheManager;
import io.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import io.servicecomb.serviceregistry.task.InstancePullTask;
import io.servicecomb.serviceregistry.task.event.ExceptionEvent;
import io.servicecomb.serviceregistry.task.event.PeriodicPullEvent;
import io.servicecomb.serviceregistry.task.event.RecoveryEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceCacheManagerOld
implements InstanceCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceCacheManagerOld.class);
    private ServiceRegistry serviceRegistry;
    protected Map<String, InstanceCache> cacheMap = new ConcurrentHashMap<String, InstanceCache>();
    private InstancePullTask pullTask;
    protected boolean cacheAvailable;
    private final Object lockObj = new Object();

    public InstanceCacheManagerOld(EventBus eventBus, ServiceRegistry serviceRegistry, ServiceRegistryConfig serviceRegistryConfig) {
        this.serviceRegistry = serviceRegistry;
        this.pullTask = new InstancePullTask(serviceRegistryConfig.getInstancePullInterval(), this);
        eventBus.register((Object)this);
    }

    private static String getKey(String appId, String microserviceName) {
        if (microserviceName.contains(":")) {
            return microserviceName.replace(":", "/");
        }
        StringBuilder sb = new StringBuilder(appId.length() + microserviceName.length() + 1);
        sb.append(appId).append("/").append(microserviceName);
        return sb.toString();
    }

    private InstanceCache create(String appId, String microserviceName, String microserviceVersionRule) {
        InstanceCache instCache = this.createInstanceCache(appId, microserviceName, microserviceVersionRule);
        if (instCache == null) {
            return null;
        }
        String key = InstanceCacheManagerOld.getKey(appId, microserviceName);
        this.cacheMap.put(key, instCache);
        return instCache;
    }

    public InstanceCache createInstanceCache(String appId, String microserviceName, String microserviceVersionRule) {
        List<MicroserviceInstance> instances = this.serviceRegistry.findServiceInstance(appId, microserviceName, microserviceVersionRule);
        if (instances == null) {
            return null;
        }
        HashMap<String, MicroserviceInstance> instMap = new HashMap<String, MicroserviceInstance>();
        for (MicroserviceInstance instance : instances) {
            instMap.put(instance.getInstanceId(), instance);
        }
        InstanceCache instCache = new InstanceCache(appId, microserviceName, microserviceVersionRule, instMap);
        return instCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceCache getOrCreate(String appId, String microserviceName, String microserviceVersionRule) {
        String key = InstanceCacheManagerOld.getKey(appId, microserviceName);
        InstanceCache cache = this.cacheMap.get(key);
        if (cache == null) {
            Object object = this.lockObj;
            synchronized (object) {
                cache = this.cacheMap.get(key);
                if (cache == null) {
                    cache = this.create(appId, microserviceName, microserviceVersionRule);
                }
            }
        }
        return cache;
    }

    @Override
    public VersionedCache getOrCreateVersionedCache(String appId, String microserviceName, String microserviceVersionRule) {
        String key = InstanceCacheManagerOld.getKey(appId, microserviceName);
        InstanceCache cache = this.cacheMap.computeIfAbsent(key, k -> this.createInstanceCache(appId, microserviceName, microserviceVersionRule));
        return cache.getVersionedCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void onInstanceUpdate(MicroserviceInstanceChangedEvent changedEvent) {
        String appId = changedEvent.getKey().getAppId();
        String microserviceName = changedEvent.getKey().getServiceName();
        String version = changedEvent.getKey().getVersion();
        String key = InstanceCacheManagerOld.getKey(appId, microserviceName);
        Object object = this.lockObj;
        synchronized (object) {
            InstanceCache instCache = this.cacheMap.get(key);
            if (instCache == null) {
                return;
            }
            Map<String, MicroserviceInstance> instMap = instCache.getInstanceMap();
            switch (changedEvent.getAction()) {
                case CREATE: 
                case UPDATE: {
                    instMap.put(changedEvent.getInstance().getInstanceId(), changedEvent.getInstance());
                    this.cacheMap.put(key, new InstanceCache(appId, microserviceName, version, instMap));
                    break;
                }
                case EXPIRE: {
                    this.cacheMap.remove(key);
                    break;
                }
                case DELETE: {
                    instMap.remove(changedEvent.getInstance().getInstanceId());
                    this.cacheMap.put(key, new InstanceCache(appId, microserviceName, version, instMap));
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        Object object = this.lockObj;
        synchronized (object) {
            this.cacheMap.clear();
        }
    }

    public Collection<InstanceCache> getCachedEntries() {
        return this.cacheMap.values();
    }

    public void updateInstanceMap(String appId, String microserviceName, InstanceCache cache) {
        String key = InstanceCacheManagerOld.getKey(appId, microserviceName);
        this.cacheMap.put(key, cache);
    }

    @Subscribe
    public void onException(ExceptionEvent event) {
        this.cacheAvailable = false;
    }

    @Subscribe
    public void onRecovered(RecoveryEvent event) {
        if (!this.cacheAvailable) {
            this.cacheAvailable = true;
            this.cleanUp();
            LOGGER.info("Reconnected to service center, clean up the provider's microservice instances cache.");
        }
    }

    @Subscribe
    public void periodicPull(PeriodicPullEvent event) {
        this.pullTask.run();
    }
}

