/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.config;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import io.servicecomb.config.ConfigUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class ConfigurationSpringInitializer
extends PropertyPlaceholderConfigurer {
    public ConfigurationSpringInitializer() {
        ConfigUtil.installDynamicConfig();
        this.setOrder(0x3FFFFFFF);
        this.setIgnoreUnresolvablePlaceholders(true);
    }

    protected Properties mergeProperties() throws IOException {
        Properties properties = super.mergeProperties();
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        Iterator iter = config.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = config.getProperty(key);
            properties.put(key, value);
        }
        return properties;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String propertyValue = super.resolvePlaceholder(placeholder, props);
        if (propertyValue == null) {
            return DynamicPropertyFactory.getInstance().getStringProperty(placeholder, null).get();
        }
        return propertyValue;
    }
}

