/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.config;

import com.netflix.config.AbstractPollingScheduler;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicWatchedConfiguration;
import com.netflix.config.PolledConfigurationSource;
import com.netflix.config.WatchedConfigurationSource;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import io.servicecomb.config.archaius.scheduler.NeverStartPollingScheduler;
import io.servicecomb.config.archaius.sources.ConfigModel;
import io.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import io.servicecomb.config.archaius.sources.MicroserviceConfigurationSource;
import io.servicecomb.config.spi.ConfigCenterConfigurationSource;
import io.servicecomb.foundation.common.utils.SPIServiceUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtil.class);
    protected static final String configCenterUrlKey = "cse.config.client.serverUri";
    private static final String MICROSERVICE_CONFIG_LOADER_KEY = "cse-microservice-config-loader";

    private ConfigUtil() {
    }

    public static Object getProperty(String key) {
        Object config = DynamicPropertyFactory.getBackingConfigurationSource();
        return ConfigUtil.getProperty(config, key);
    }

    public static Object getProperty(Object config, String key) {
        if (null != config && Configuration.class.isInstance(config)) {
            Configuration configuration = (Configuration)config;
            return configuration.getProperty(key);
        }
        return null;
    }

    private static void setMicroserviceConfigLoader(Configuration config, MicroserviceConfigLoader loader) {
        config.setProperty(MICROSERVICE_CONFIG_LOADER_KEY, (Object)loader);
    }

    public static MicroserviceConfigLoader getMicroserviceConfigLoader() {
        return (MicroserviceConfigLoader)ConfigUtil.getProperty(MICROSERVICE_CONFIG_LOADER_KEY);
    }

    public static MicroserviceConfigLoader getMicroserviceConfigLoader(Configuration config) {
        return (MicroserviceConfigLoader)ConfigUtil.getProperty(config, MICROSERVICE_CONFIG_LOADER_KEY);
    }

    public static ConcurrentCompositeConfiguration createLocalConfig() {
        MicroserviceConfigLoader loader = new MicroserviceConfigLoader();
        loader.loadAndSort();
        LOGGER.info("create local config:");
        for (ConfigModel configModel : loader.getConfigModels()) {
            LOGGER.info(" {}.", (Object)configModel.getUrl());
        }
        ConcurrentCompositeConfiguration config = ConfigUtil.createLocalConfig(loader.getConfigModels());
        ConfigUtil.setMicroserviceConfigLoader((Configuration)config, loader);
        return config;
    }

    public static ConcurrentCompositeConfiguration createLocalConfig(List<ConfigModel> configModelList) {
        ConcurrentCompositeConfiguration config = new ConcurrentCompositeConfiguration();
        ConfigUtil.duplicateServiceCombConfigToCse(config, (AbstractConfiguration)new ConcurrentMapConfiguration((Configuration)new SystemConfiguration()), "configFromSystem");
        ConfigUtil.duplicateServiceCombConfigToCse(config, (AbstractConfiguration)new ConcurrentMapConfiguration((Configuration)new EnvironmentConfiguration()), "configFromEnvironment");
        ConfigUtil.duplicateServiceCombConfigToCse(config, (AbstractConfiguration)new DynamicConfiguration((PolledConfigurationSource)new MicroserviceConfigurationSource(configModelList), (AbstractPollingScheduler)new NeverStartPollingScheduler()), "configFromYamlFile");
        return config;
    }

    private static void duplicateServiceCombConfigToCse(AbstractConfiguration source) {
        Iterator keys = source.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("servicecomb.")) continue;
            String cseKey = "cse." + key.substring(key.indexOf(".") + 1);
            source.addProperty(cseKey, source.getProperty(key));
        }
    }

    private static void duplicateServiceCombConfigToCse(ConcurrentCompositeConfiguration compositeConfiguration, AbstractConfiguration source, String sourceName) {
        ConfigUtil.duplicateServiceCombConfigToCse(source);
        compositeConfiguration.addConfiguration(source, sourceName);
    }

    public static DynamicWatchedConfiguration createConfigFromConfigCenter(Configuration localConfiguration) {
        if (localConfiguration.getProperty(configCenterUrlKey) == null) {
            LOGGER.info("config center URL is missing, skip to load configuration from config center");
            return null;
        }
        ConfigCenterConfigurationSource configCenterConfigurationSource = (ConfigCenterConfigurationSource)SPIServiceUtils.getTargetService(ConfigCenterConfigurationSource.class);
        if (null == configCenterConfigurationSource) {
            LOGGER.info("config center SPI service can not find, skip to load configuration from config center");
            return null;
        }
        configCenterConfigurationSource.init(localConfiguration);
        return new DynamicWatchedConfiguration((WatchedConfigurationSource)configCenterConfigurationSource);
    }

    public static AbstractConfiguration createDynamicConfig() {
        LOGGER.info("create dynamic config:");
        ConcurrentCompositeConfiguration config = ConfigUtil.createLocalConfig();
        DynamicWatchedConfiguration configFromConfigCenter = ConfigUtil.createConfigFromConfigCenter((Configuration)config);
        if (configFromConfigCenter != null) {
            ConcurrentMapConfiguration injectConfig = new ConcurrentMapConfiguration();
            config.addConfigurationAtFront((AbstractConfiguration)injectConfig, "extraInjectConfig");
            ConfigUtil.duplicateServiceCombConfigToCse((AbstractConfiguration)configFromConfigCenter);
            config.addConfigurationAtFront((AbstractConfiguration)configFromConfigCenter, "configCenterConfig");
            configFromConfigCenter.getSource().addUpdateListener((WatchedUpdateListener)new ServiceCombPropertyUpdateListener(injectConfig));
        }
        return config;
    }

    public static void installDynamicConfig() {
        if (ConfigurationManager.isConfigurationInstalled()) {
            LOGGER.warn("Configuration installed by others, will ignore this configuration.");
            return;
        }
        AbstractConfiguration dynamicConfig = ConfigUtil.createDynamicConfig();
        ConfigurationManager.install((AbstractConfiguration)dynamicConfig);
    }

    private static class ServiceCombPropertyUpdateListener
    implements WatchedUpdateListener {
        private final ConcurrentMapConfiguration injectConfig;

        ServiceCombPropertyUpdateListener(ConcurrentMapConfiguration injectConfig) {
            this.injectConfig = injectConfig;
        }

        public void updateConfiguration(WatchedUpdateResult watchedUpdateResult) {
            Map changes;
            Map deletes;
            Map adds = watchedUpdateResult.getAdded();
            if (adds != null) {
                for (Object add : adds.keySet()) {
                    if (!((String)add).startsWith("servicecomb.")) continue;
                    String key = "cse." + ((String)add).substring(((String)add).indexOf(".") + 1);
                    this.injectConfig.addProperty(key, adds.get(add));
                }
            }
            if ((deletes = watchedUpdateResult.getDeleted()) != null) {
                for (String delete : deletes.keySet()) {
                    if (!delete.startsWith("servicecomb.")) continue;
                    this.injectConfig.clearProperty("cse." + delete.substring(delete.indexOf(".") + 1));
                }
            }
            if ((changes = watchedUpdateResult.getChanged()) != null) {
                for (String change : changes.keySet()) {
                    if (!change.startsWith("servicecomb.")) continue;
                    String key = "cse." + change.substring(change.indexOf(".") + 1);
                    this.injectConfig.setProperty(key, changes.get(change));
                }
            }
        }
    }
}

