/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.client.ClientFactory;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.loadbalancer.AvailabilityFilteringRule;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.loadbalancer.ZoneSnapshot;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneAwareLoadBalancer<T extends Server>
extends DynamicServerListLoadBalancer<T> {
    private ConcurrentHashMap<String, BaseLoadBalancer> balancers = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(ZoneAwareLoadBalancer.class);
    private volatile DynamicDoubleProperty triggeringLoad;
    private volatile DynamicDoubleProperty triggeringBlackoutPercentage;
    private static final DynamicBooleanProperty ENABLED = DynamicPropertyFactory.getInstance().getBooleanProperty("ZoneAwareNIWSDiscoveryLoadBalancer.enabled", true);

    void setUpServerList(List<Server> upServerList) {
        this.upServerList = upServerList;
    }

    public ZoneAwareLoadBalancer() {
    }

    @Deprecated
    public ZoneAwareLoadBalancer(IClientConfig clientConfig, IRule rule, IPing ping, ServerList<T> serverList, ServerListFilter<T> filter) {
        super(clientConfig, rule, ping, serverList, filter);
    }

    public ZoneAwareLoadBalancer(IClientConfig clientConfig, IRule rule, IPing ping, ServerList<T> serverList, ServerListFilter<T> filter, ServerListUpdater serverListUpdater) {
        super(clientConfig, rule, ping, serverList, filter, serverListUpdater);
    }

    public ZoneAwareLoadBalancer(IClientConfig niwsClientConfig) {
        super(niwsClientConfig);
    }

    @Override
    protected void setServerListForZones(Map<String, List<Server>> zoneServersMap) {
        super.setServerListForZones(zoneServersMap);
        if (this.balancers == null) {
            this.balancers = new ConcurrentHashMap();
        }
        for (Map.Entry<String, List<Server>> entry : zoneServersMap.entrySet()) {
            String zone = entry.getKey().toLowerCase();
            this.getLoadBalancer(zone).setServersList(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.balancers.entrySet()) {
            if (zoneServersMap.keySet().contains(entry.getKey())) continue;
            ((BaseLoadBalancer)entry.getValue()).setServersList(Collections.emptyList());
        }
    }

    @Override
    public Server chooseServer(Object key) {
        if (!ENABLED.get() || this.getLoadBalancerStats().getAvailableZones().size() <= 1) {
            logger.debug("Zone aware logic disabled or there is only one zone");
            return super.chooseServer(key);
        }
        Server server = null;
        try {
            LoadBalancerStats lbStats = this.getLoadBalancerStats();
            Map<String, ZoneSnapshot> zoneSnapshot = ZoneAvoidanceRule.createSnapshot(lbStats);
            logger.debug("Zone snapshots: {}", zoneSnapshot);
            if (this.triggeringLoad == null) {
                this.triggeringLoad = DynamicPropertyFactory.getInstance().getDoubleProperty("ZoneAwareNIWSDiscoveryLoadBalancer." + this.getName() + ".triggeringLoadPerServerThreshold", 0.2);
            }
            if (this.triggeringBlackoutPercentage == null) {
                this.triggeringBlackoutPercentage = DynamicPropertyFactory.getInstance().getDoubleProperty("ZoneAwareNIWSDiscoveryLoadBalancer." + this.getName() + ".avoidZoneWithBlackoutPercetage", 0.99999);
            }
            Set<String> availableZones = ZoneAvoidanceRule.getAvailableZones(zoneSnapshot, this.triggeringLoad.get(), this.triggeringBlackoutPercentage.get());
            logger.debug("Available zones: {}", availableZones);
            if (availableZones != null && availableZones.size() < zoneSnapshot.keySet().size()) {
                String zone = ZoneAvoidanceRule.randomChooseZone(zoneSnapshot, availableZones);
                logger.debug("Zone chosen: {}", (Object)zone);
                if (zone != null) {
                    BaseLoadBalancer zoneLoadBalancer = this.getLoadBalancer(zone);
                    server = zoneLoadBalancer.chooseServer(key);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error choosing server using zone aware logic for load balancer={}", (Object)this.name, (Object)e);
        }
        if (server != null) {
            return server;
        }
        logger.debug("Zone avoidance logic is not invoked.");
        return super.chooseServer(key);
    }

    @VisibleForTesting
    BaseLoadBalancer getLoadBalancer(String zone) {
        BaseLoadBalancer loadBalancer = this.balancers.get(zone = zone.toLowerCase());
        if (loadBalancer == null) {
            IRule rule = this.cloneRule(this.getRule());
            loadBalancer = new BaseLoadBalancer(this.getName() + "_" + zone, rule, this.getLoadBalancerStats());
            BaseLoadBalancer prev = this.balancers.putIfAbsent(zone, loadBalancer);
            if (prev != null) {
                loadBalancer = prev;
            }
        }
        return loadBalancer;
    }

    private IRule cloneRule(IRule toClone) {
        IRule rule;
        if (toClone == null) {
            rule = new AvailabilityFilteringRule();
        } else {
            String ruleClass = toClone.getClass().getName();
            try {
                rule = (IRule)ClientFactory.instantiateInstanceWithClientConfig(ruleClass, this.getClientConfig());
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception creating rule for ZoneAwareLoadBalancer", e);
            }
        }
        return rule;
    }

    @Override
    public void setRule(IRule rule) {
        super.setRule(rule);
        if (this.balancers != null) {
            for (String zone : this.balancers.keySet()) {
                this.balancers.get(zone).setRule(this.cloneRule(rule));
            }
        }
    }
}

