/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.utils;

import com.jfinal.json.IJsonFactory;
import com.jfinal.json.Json;
import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class JsonUtils {
    private static IJsonFactory jsonFactory = null;

    private JsonUtils() {
    }

    public static String toJson(Model<? extends Model<?>> model) {
        return JsonUtils.toJson(CPI.getAttrs(model));
    }

    public static String toJson(Collection<Model<? extends Model<?>>> models) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Model<Model<?>> model : models) {
            list.add(CPI.getAttrs(model));
        }
        return JsonUtils.toJson(list);
    }

    public static String toJson(Record record) {
        return JsonUtils.toJson(record.getColumns());
    }

    public static String toJson(List<Record> records) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Record record : records) {
            list.add(record.getColumns());
        }
        return JsonUtils.toJson(list);
    }

    public static void setJsonFactory(IJsonFactory jsonFactory) {
        JsonUtils.jsonFactory = jsonFactory;
    }

    public static String toJson(Object object) {
        if (jsonFactory == null) {
            return Json.getJson().toJson(object);
        }
        return jsonFactory.getJson().toJson(object);
    }

    public static <T> T parse(String jsonString, Class<T> valueType) {
        if (jsonFactory == null) {
            return (T)Json.getJson().parse(jsonString, valueType);
        }
        return (T)jsonFactory.getJson().parse(jsonString, valueType);
    }
}

