/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpUserBlacklistService;
import me.chanjar.weixin.mp.bean.result.WxMpUserBlacklistGetResult;

public class WxMpUserBlacklistServiceImpl
implements WxMpUserBlacklistService {
    private static final String API_BLACKLIST_PREFIX = "https://api.weixin.qq.com/cgi-bin/tags/members";
    private WxMpService wxMpService;

    public WxMpUserBlacklistServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxMpUserBlacklistGetResult getBlacklist(String nextOpenid) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("begin_openid", nextOpenid);
        String url = "https://api.weixin.qq.com/cgi-bin/tags/members/getblacklist";
        String responseContent = (String)this.wxMpService.execute(SimplePostRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp()), url, jsonObject.toString());
        return WxMpUserBlacklistGetResult.fromJson(responseContent);
    }

    @Override
    public void pushToBlacklist(List<String> openidList) throws WxErrorException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("openid_list", openidList);
        String url = "https://api.weixin.qq.com/cgi-bin/tags/members/batchblacklist";
        this.wxMpService.execute(SimplePostRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp()), url, new Gson().toJson(map));
    }

    @Override
    public void pullFromBlacklist(List<String> openidList) throws WxErrorException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("openid_list", openidList);
        String url = "https://api.weixin.qq.com/cgi-bin/tags/members/batchunblacklist";
        this.wxMpService.execute(SimplePostRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp()), url, new Gson().toJson(map));
    }
}

