/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.schema;

import com.dtflys.forest.beans.ClientFactoryBean;
import com.dtflys.forest.schema.ForestConfigurationBeanDefinitionParser;
import com.dtflys.forest.utils.ClientFactoryBeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ForestClientBeanDefinitionParser
implements BeanDefinitionParser {
    private static Log log = LogFactory.getLog(ForestConfigurationBeanDefinitionParser.class);
    private final Class factoryBeanClass = ClientFactoryBean.class;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setLazyInit(false);
        String id = element.getAttribute("id");
        if (id == null || id.length() == 0) {
            String generatedBeanName;
            id = generatedBeanName = this.factoryBeanClass.getName();
            int counter = 2;
            while (parserContext.getRegistry().containsBeanDefinition(id)) {
                id = generatedBeanName + counter++;
            }
        }
        if (id != null && id.length() > 0) {
            if (parserContext.getRegistry().containsBeanDefinition(id)) {
                throw new IllegalStateException("Duplicate spring bean id " + id);
            }
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        }
        String configurationId = element.getAttribute("configuration");
        String clientClassName = element.getAttribute("class");
        ClientFactoryBeanUtils.setupClientFactoryBean((AbstractBeanDefinition)beanDefinition, configurationId, clientClassName);
        log.info((Object)("[Forest] Created Forest Client Bean with name '" + id + "' and Proxy of '" + clientClassName + "' client interface"));
        return beanDefinition;
    }
}

