/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class ReflectionKit {
    private static final Log logger = LogFactory.getLog(ReflectionKit.class);
    private static final Map<Class, List<Field>> classFieldCache = new ConcurrentHashMap<Class, List<Field>>();

    public static String getMethodCapitalize(Field field, String str) {
        Class<?> fieldType = field.getType();
        return StringUtils.concatCapitalize(Boolean.TYPE.equals(fieldType) ? "is" : "get", str);
    }

    public static String setMethodCapitalize(Field field, String str) {
        Class<?> fieldType = field.getType();
        return StringUtils.concatCapitalize("set", str);
    }

    public static Object getMethodValue(Class<?> cls, Object entity, String str) {
        Map<String, Field> fieldMaps = ReflectionKit.getFieldMap(cls);
        try {
            Assert.notEmpty(fieldMaps, "Error: NoSuchField in %s for %s.  Cause:", cls.getSimpleName(), str);
            Method method = cls.getMethod(ReflectionKit.getMethodCapitalize(fieldMaps.get(str), str), new Class[0]);
            return method.invoke(entity, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionUtils.mpe("Error: NoSuchMethod in %s.  Cause:", e, cls.getSimpleName());
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.mpe("Error: Cannot execute a private method. in %s.  Cause:", e, cls.getSimpleName());
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtils.mpe("Error: InvocationTargetException on getMethodValue.  Cause:" + e, new Object[0]);
        }
    }

    public static Object getMethodValue(Object entity, String str) {
        if (null == entity) {
            return null;
        }
        return ReflectionKit.getMethodValue(entity.getClass(), entity, str);
    }

    public static Class getSuperClassGenericType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(String.format("Warn: %s's superclass not ParameterizedType", clazz.getSimpleName()));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn(String.format("Warn: Index: %s, Size of %s's Parameterized Type: %s .", index, clazz.getSimpleName(), params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(String.format("Warn: %s not set the actual class on superclass generic parameter", clazz.getSimpleName()));
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        List<Field> fieldList = ReflectionKit.getFieldList(clazz);
        if (CollectionUtils.isNotEmpty(fieldList)) {
            LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
            fieldList.forEach(field -> fieldMap.put(field.getName(), (Field)field));
            return fieldMap;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getFieldList(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return Collections.emptyList();
        }
        List<Field> fields = classFieldCache.get(clazz);
        if (CollectionUtils.isEmpty(fields)) {
            Map<Class, List<Field>> map = classFieldCache;
            synchronized (map) {
                fields = ReflectionKit.doGetFieldList(clazz);
                classFieldCache.put(clazz, fields);
            }
        }
        return fields;
    }

    public static List<Field> doGetFieldList(Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return Collections.emptyList();
        }
        List fieldList = Stream.of(clazz.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isTransient(field.getModifiers())).collect(Collectors.toCollection(LinkedList::new));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return fieldList;
        }
        return ReflectionKit.excludeOverrideSuperField(fieldList, ReflectionKit.getFieldList(superClass));
    }

    public static List<Field> excludeOverrideSuperField(List<Field> fieldList, List<Field> superFieldList) {
        Map fieldMap = fieldList.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
        superFieldList.stream().filter(field -> fieldMap.get(field.getName()) == null).forEach(fieldList::add);
        return fieldList;
    }
}

