/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.netty;

import com.alibaba.dubbo.common.utils.Assert;
import com.alibaba.dubbo.remoting.buffer.ChannelBufferFactory;
import com.alibaba.dubbo.remoting.buffer.ChannelBuffers;
import com.alibaba.dubbo.remoting.transport.netty.NettyBackedChannelBufferFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;

public class NettyBackedChannelBuffer
implements com.alibaba.dubbo.remoting.buffer.ChannelBuffer {
    private ChannelBuffer buffer;

    public NettyBackedChannelBuffer(ChannelBuffer buffer) {
        Assert.notNull((Object)buffer, (String)"buffer == null");
        this.buffer = buffer;
    }

    public ChannelBuffer nettyChannelBuffer() {
        return this.buffer;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public com.alibaba.dubbo.remoting.buffer.ChannelBuffer copy(int index, int length) {
        return new NettyBackedChannelBuffer(this.buffer.copy(index, length));
    }

    public ChannelBufferFactory factory() {
        return NettyBackedChannelBufferFactory.getInstance();
    }

    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    public void getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, com.alibaba.dubbo.remoting.buffer.ChannelBuffer dst, int dstIndex, int length) {
        byte[] data = new byte[length];
        this.buffer.getBytes(index, data, 0, length);
        dst.setBytes(dstIndex, data, 0, length);
    }

    public void getBytes(int index, OutputStream dst, int length) throws IOException {
        this.buffer.getBytes(index, dst, length);
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public void setByte(int index, int value) {
        this.buffer.setByte(index, value);
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    public void setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
    }

    public void setBytes(int index, com.alibaba.dubbo.remoting.buffer.ChannelBuffer src, int srcIndex, int length) {
        byte[] data = new byte[length];
        this.buffer.getBytes(srcIndex, data, 0, length);
        this.setBytes(0, data, index, length);
    }

    public int setBytes(int index, InputStream src, int length) throws IOException {
        return this.buffer.setBytes(index, src, length);
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        return this.buffer.toByteBuffer(index, length);
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public void clear() {
        this.buffer.clear();
    }

    public com.alibaba.dubbo.remoting.buffer.ChannelBuffer copy() {
        return new NettyBackedChannelBuffer(this.buffer.copy());
    }

    public void discardReadBytes() {
        this.buffer.discardReadBytes();
    }

    public void ensureWritableBytes(int writableBytes) {
        this.buffer.ensureWritableBytes(writableBytes);
    }

    public void getBytes(int index, byte[] dst) {
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, com.alibaba.dubbo.remoting.buffer.ChannelBuffer dst) {
        this.getBytes(index, dst, dst.writableBytes());
    }

    public void getBytes(int index, com.alibaba.dubbo.remoting.buffer.ChannelBuffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.getBytes(index, dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
    }

    public void markReaderIndex() {
        this.buffer.markReaderIndex();
    }

    public void markWriterIndex() {
        this.buffer.markWriterIndex();
    }

    public boolean readable() {
        return this.buffer.readable();
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public byte readByte() {
        return this.buffer.readByte();
    }

    public void readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
    }

    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
    }

    public void readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
    }

    public void readBytes(com.alibaba.dubbo.remoting.buffer.ChannelBuffer dst) {
        this.readBytes(dst, dst.writableBytes());
    }

    public void readBytes(com.alibaba.dubbo.remoting.buffer.ChannelBuffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.readBytes(dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
    }

    public void readBytes(com.alibaba.dubbo.remoting.buffer.ChannelBuffer dst, int dstIndex, int length) {
        if (this.readableBytes() < length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] data = new byte[length];
        this.buffer.readBytes(data, 0, length);
        dst.setBytes(dstIndex, data, 0, length);
    }

    public com.alibaba.dubbo.remoting.buffer.ChannelBuffer readBytes(int length) {
        return new NettyBackedChannelBuffer(this.buffer.readBytes(length));
    }

    public void resetReaderIndex() {
        this.buffer.resetReaderIndex();
    }

    public void resetWriterIndex() {
        this.buffer.resetWriterIndex();
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public void readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
    }

    public void readBytes(OutputStream dst, int length) throws IOException {
        this.buffer.readBytes(dst, length);
    }

    public void setBytes(int index, byte[] src) {
        this.buffer.setBytes(index, src);
    }

    public void setBytes(int index, com.alibaba.dubbo.remoting.buffer.ChannelBuffer src) {
        this.setBytes(index, src, src.readableBytes());
    }

    public void setBytes(int index, com.alibaba.dubbo.remoting.buffer.ChannelBuffer src, int length) {
        if (length > src.readableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.setBytes(index, src, src.readerIndex(), length);
        src.readerIndex(src.readerIndex() + length);
    }

    public void setIndex(int readerIndex, int writerIndex) {
        this.buffer.setIndex(readerIndex, writerIndex);
    }

    public void skipBytes(int length) {
        this.buffer.skipBytes(length);
    }

    public ByteBuffer toByteBuffer() {
        return this.buffer.toByteBuffer();
    }

    public boolean writable() {
        return this.buffer.writable();
    }

    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    public void writeByte(int value) {
        this.buffer.writeByte(value);
    }

    public void writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
    }

    public void writeBytes(byte[] src, int index, int length) {
        this.buffer.writeBytes(src, index, length);
    }

    public void writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
    }

    public void writeBytes(com.alibaba.dubbo.remoting.buffer.ChannelBuffer src) {
        this.writeBytes(src, src.readableBytes());
    }

    public void writeBytes(com.alibaba.dubbo.remoting.buffer.ChannelBuffer src, int length) {
        if (length > src.readableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.writeBytes(src, src.readerIndex(), length);
        src.readerIndex(src.readerIndex() + length);
    }

    public void writeBytes(com.alibaba.dubbo.remoting.buffer.ChannelBuffer src, int srcIndex, int length) {
        byte[] data = new byte[length];
        src.getBytes(srcIndex, data, 0, length);
        this.writeBytes(data, 0, length);
    }

    public int writeBytes(InputStream src, int length) throws IOException {
        return this.buffer.writeBytes(src, length);
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public void writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
    }

    public int compareTo(com.alibaba.dubbo.remoting.buffer.ChannelBuffer o) {
        return ChannelBuffers.compare((com.alibaba.dubbo.remoting.buffer.ChannelBuffer)this, (com.alibaba.dubbo.remoting.buffer.ChannelBuffer)o);
    }
}

