/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.qr.scheme;

import java.util.Map;
import org.tio.utils.qr.scheme.Schema;
import org.tio.utils.qr.scheme.SchemeUtil;

public class Telephone
extends Schema {
    private static final String TEL = "tel";
    private String telephone;

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.trim().toLowerCase().startsWith(TEL)) {
            throw new IllegalArgumentException("this is not a valid telephone code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code.trim().toLowerCase());
        if (parameters.containsKey(TEL)) {
            this.setTelephone(parameters.get(TEL));
        }
        return this;
    }

    @Override
    public String generateString() {
        return "tel:" + this.telephone;
    }

    public String toString() {
        return this.generateString();
    }

    public static Telephone parse(String telephone) {
        Telephone tel = new Telephone();
        tel.parseSchema(telephone);
        return tel;
    }
}

