/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.qr.scheme;

import java.util.Map;
import org.tio.utils.qr.scheme.Schema;
import org.tio.utils.qr.scheme.SchemeUtil;

public class MMS
extends Schema {
    private static final String MMS = "mms";
    private String number;
    private String subject;

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.trim().toLowerCase().startsWith(MMS)) {
            throw new IllegalArgumentException("this is not a valid sms code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code.trim().toLowerCase());
        if (parameters.containsKey(MMS)) {
            this.setNumber(parameters.get(MMS));
        }
        if (this.getNumber() != null && parameters.containsKey(this.getNumber())) {
            this.setSubject(parameters.get(this.getNumber()));
        }
        return this;
    }

    @Override
    public String generateString() {
        return "mms:" + this.number + (this.subject != null ? ":" + this.subject : "");
    }

    public String toString() {
        return this.generateString();
    }

    public static MMS parse(String mmsCode) {
        MMS mms = new MMS();
        mms.parseSchema(mmsCode);
        return mms;
    }
}

