/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.qr.scheme;

import java.util.Map;
import org.tio.utils.qr.scheme.Schema;
import org.tio.utils.qr.scheme.SchemeUtil;

public class KddiAu
extends Schema {
    private static final String BEGIN = "MEMORY";
    private static final String NAME1 = "NAME1";
    private static final String NAME2 = "NAME2";
    private static final String MAIL1 = "MAIL1";
    private static final String MAIL2 = "MAIL2";
    private static final String MAIL3 = "MAIL3";
    private static final String TEL1 = "TEL1";
    private static final String TEL2 = "TEL2";
    private static final String TEL3 = "TEL3";
    private static final String ADD = "ADD";
    private String name1;
    private String name2;
    private String address;
    private String telephone1;
    private String telephone2;
    private String telephone3;
    private String email1;
    private String email2;
    private String email3;

    public KddiAu() {
    }

    public KddiAu(String name1) {
        this.name1 = name1;
    }

    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTelephone1() {
        return this.telephone1;
    }

    public void setTelephone1(String telephone1) {
        this.telephone1 = telephone1;
    }

    public String getTelephone2() {
        return this.telephone2;
    }

    public void setTelephone2(String telephone2) {
        this.telephone2 = telephone2;
    }

    public String getTelephone3() {
        return this.telephone3;
    }

    public void setTelephone3(String telephone3) {
        this.telephone3 = telephone3;
    }

    public String getEmail1() {
        return this.email1;
    }

    public void setEmail1(String email1) {
        this.email1 = email1;
    }

    public String getEmail2() {
        return this.email2;
    }

    public void setEmail2(String email2) {
        this.email2 = email2;
    }

    public String getEmail3() {
        return this.email3;
    }

    public void setEmail3(String email3) {
        this.email3 = email3;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.startsWith(BEGIN)) {
            throw new IllegalArgumentException("this is not a valid KDDI AU code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code);
        if (parameters.containsKey(NAME1)) {
            this.setName1(parameters.get(NAME1));
        }
        if (parameters.containsKey(NAME2)) {
            this.setName2(parameters.get(NAME2));
        }
        if (parameters.containsKey(ADD)) {
            this.setAddress(parameters.get(ADD));
        }
        if (parameters.containsKey(TEL1)) {
            this.setTelephone1(parameters.get(TEL1));
        }
        if (parameters.containsKey(TEL2)) {
            this.setTelephone1(parameters.get(TEL2));
        }
        if (parameters.containsKey(TEL3)) {
            this.setTelephone1(parameters.get(TEL3));
        }
        if (parameters.containsKey(MAIL1)) {
            this.setEmail1(parameters.get(MAIL1));
        }
        if (parameters.containsKey(MAIL2)) {
            this.setEmail2(parameters.get(MAIL2));
        }
        if (parameters.containsKey(MAIL3)) {
            this.setEmail3(parameters.get(MAIL3));
        }
        return this;
    }

    @Override
    public String generateString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BEGIN).append("\n");
        if (this.name1 != null) {
            sb.append(NAME1).append(":").append(this.name1);
        }
        if (this.name2 != null) {
            sb.append(NAME2).append(":").append(this.name2);
        }
        if (this.address != null) {
            sb.append(ADD).append(":").append(this.address);
        }
        if (this.telephone1 != null) {
            sb.append(TEL1).append(":").append(this.telephone1);
        }
        if (this.telephone2 != null) {
            sb.append(TEL2).append(":").append(this.telephone2);
        }
        if (this.telephone3 != null) {
            sb.append(TEL3).append(":").append(this.telephone3);
        }
        if (this.email1 != null) {
            sb.append(MAIL1).append(":").append(this.email1);
        }
        if (this.email2 != null) {
            sb.append(MAIL2).append(":").append(this.email2);
        }
        if (this.email3 != null) {
            sb.append(MAIL3).append(":").append(this.email3);
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.generateString();
    }

    public static KddiAu parse(String kddiAuCode) {
        KddiAu kddiAu = new KddiAu();
        kddiAu.parseSchema(kddiAuCode);
        return kddiAu;
    }
}

