/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.lock;

import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.lock.ObjWithLock;

public class MapWithLock<K, V>
extends ObjWithLock<Map<K, V>> {
    private static final long serialVersionUID = -652862323697152866L;
    private static final Logger log = LoggerFactory.getLogger(MapWithLock.class);

    public MapWithLock(Map<K, V> map) {
        super(map);
    }

    public MapWithLock(Map<K, V> map, ReentrantReadWriteLock lock) {
        super(map, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Map map = (Map)this.getObj();
            V v = map.put(key, value);
            return v;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Map map = (Map)this.getObj();
            V oldValue = map.putIfAbsent(key, value);
            if (oldValue == null) {
                V v = value;
                return v;
            }
            V v = oldValue;
            return v;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<K, V> otherMap) {
        if (otherMap == null || otherMap.isEmpty()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Map map = (Map)this.getObj();
            map.putAll(otherMap);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Map map = (Map)this.getObj();
            Object v = map.remove(key);
            return v;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return null;
    }

    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Map map = (Map)this.getObj();
            map.clear();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            Map map = (Map)this.getObj();
            Object v = map.get(key);
            return v;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            Map map = (Map)this.getObj();
            int n = map.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }
}

