/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache.caffeine;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.cache.ICache;
import org.tio.utils.caffeine.CaffeineUtils;

public class CaffeineCache
implements ICache {
    private static Logger log = LoggerFactory.getLogger(CaffeineCache.class);
    public static Map<String, CaffeineCache> map = new HashMap<String, CaffeineCache>();
    private LoadingCache<String, Serializable> loadingCache = null;
    private LoadingCache<String, Serializable> temporaryLoadingCache = null;

    public static CaffeineCache getCache(String cacheName, boolean skipNull) {
        CaffeineCache CaffeineCache2 = map.get(cacheName);
        if (CaffeineCache2 == null && !skipNull) {
            log.error("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c\uff0c\u8bf7\u521d\u59cb\u5316\u65f6\u8c03\u7528\uff1a{}.register(cacheName, timeToLiveSeconds, timeToIdleSeconds)", (Object)cacheName, (Object)CaffeineCache.class.getSimpleName());
        }
        return CaffeineCache2;
    }

    public static CaffeineCache getCache(String cacheName) {
        return CaffeineCache.getCache(cacheName, false);
    }

    public static CaffeineCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        CaffeineCache CaffeineCache2 = CaffeineCache.register(cacheName, timeToLiveSeconds, timeToIdleSeconds, null);
        return CaffeineCache2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CaffeineCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, RemovalListener<String, Serializable> removalListener) {
        CaffeineCache caffeineCache = map.get(cacheName);
        if (caffeineCache != null) return caffeineCache;
        Class<CaffeineCache> clazz = CaffeineCache.class;
        synchronized (CaffeineCache.class) {
            caffeineCache = map.get(cacheName);
            if (caffeineCache != null) return caffeineCache;
            Integer initialCapacity = 10;
            Integer maximumSize = 5000000;
            boolean recordStats = false;
            LoadingCache<String, Serializable> loadingCache = CaffeineUtils.createLoadingCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats, removalListener);
            Integer temporaryMaximumSize = 500000;
            LoadingCache<String, Serializable> temporaryLoadingCache = CaffeineUtils.createLoadingCache(cacheName, 10L, null, initialCapacity, temporaryMaximumSize, recordStats, removalListener);
            caffeineCache = new CaffeineCache(loadingCache, temporaryLoadingCache);
            map.put(cacheName, caffeineCache);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return caffeineCache;
        }
    }

    private CaffeineCache(LoadingCache<String, Serializable> loadingCache, LoadingCache<String, Serializable> temporaryLoadingCache) {
        this.loadingCache = loadingCache;
        this.temporaryLoadingCache = temporaryLoadingCache;
    }

    @Override
    public void clear() {
        this.loadingCache.invalidateAll();
        this.temporaryLoadingCache.invalidateAll();
    }

    @Override
    public Serializable get(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Serializable ret = (Serializable)this.loadingCache.getIfPresent((Object)key);
        if (ret == null) {
            ret = (Serializable)this.temporaryLoadingCache.getIfPresent((Object)key);
        }
        return ret;
    }

    public Collection<String> keys() {
        ConcurrentMap map = this.loadingCache.asMap();
        return map.keySet();
    }

    @Override
    public void put(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.loadingCache.put((Object)key, (Object)value);
    }

    @Override
    public void putTemporary(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.temporaryLoadingCache.put((Object)key, (Object)value);
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.loadingCache.invalidate((Object)key);
        this.temporaryLoadingCache.invalidate((Object)key);
    }

    public ConcurrentMap<String, Serializable> asMap() {
        return this.loadingCache.asMap();
    }

    public long size() {
        return this.loadingCache.estimatedSize();
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return (T)this.get(key);
    }

    @Override
    public long ttl(String key) {
        throw new RuntimeException("\u4e0d\u652f\u6301ttl");
    }
}

