/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.api.RFuture;
import org.redisson.api.RMultimap;
import org.redisson.api.RMultimapReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.misc.Hash;
import org.redisson.reactive.RedissonExpirableReactive;

abstract class RedissonBaseMultimapReactive<K, V>
extends RedissonExpirableReactive
implements RMultimapReactive<K, V> {
    private final RMultimap<K, V> instance;

    public RedissonBaseMultimapReactive(RMultimap<K, V> instance, CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name, instance);
        this.instance = instance;
    }

    public RedissonBaseMultimapReactive(RMultimap<K, V> instance, Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name, instance);
        this.instance = instance;
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonBaseMultimapReactive.this.instance.sizeAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> containsKey(final Object key) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.containsKeyAsync(key);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsValue(final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.containsValueAsync(value);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsEntry(final Object key, final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.containsEntryAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> put(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.putAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> remove(final Object key, final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.removeAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> putAll(final K key, final Iterable<? extends V> values) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.putAllAsync(key, values);
            }
        });
    }

    @Override
    public Publisher<Integer> keySize() {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonBaseMultimapReactive.this.instance.keySizeAsync();
            }
        });
    }

    @Override
    public Publisher<Long> fastRemove(final K ... keys) {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonBaseMultimapReactive.this.instance.fastRemoveAsync(keys);
            }
        });
    }

    @Override
    public Publisher<Set<K>> readAllKeySet() {
        return this.reactive(new Supplier<RFuture<Set<K>>>(){

            @Override
            public RFuture<Set<K>> get() {
                return RedissonBaseMultimapReactive.this.instance.readAllKeySetAsync();
            }
        });
    }

    protected String hash(ByteBuf objectState) {
        return Hash.hash128toBase64(objectState);
    }

    protected String hashAndRelease(ByteBuf objectState) {
        try {
            String string = Hash.hash128toBase64(objectState);
            return string;
        }
        finally {
            objectState.release();
        }
    }

    String getValuesName(String hash) {
        return "{" + this.getName() + "}:" + hash;
    }

    protected <T> Publisher<T> fastRemove(List<Object> mapKeys, List<Object> listKeys, RedisCommand<T> evalCommandType) {
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, evalCommandType, "local res = redis.call('hdel', KEYS[1], unpack(ARGV)); if res > 0 then redis.call('del', unpack(KEYS, 2, #KEYS)); end; return res; ", listKeys, mapKeys.toArray());
    }
}

