/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedConnectionManager
extends MasterSlaveConnectionManager {
    private static final String ROLE_KEY = "role";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AtomicReference<URI> currentMaster = new AtomicReference();
    private ScheduledFuture<?> monitorFuture;

    public ReplicatedConnectionManager(ReplicatedServersConfig cfg, Config config, UUID id) {
        super(config, id);
        this.config = this.create(cfg);
        this.initTimer(this.config);
        for (URI addr : cfg.getNodeAddresses()) {
            RFuture<RedisConnection> connectionFuture = this.connectToNode(cfg, addr, null, addr.getHost());
            connectionFuture.awaitUninterruptibly();
            RedisConnection connection = connectionFuture.getNow();
            if (connection == null) continue;
            Role role = Role.valueOf(connection.sync(RedisCommands.INFO_REPLICATION, new Object[0]).get(ROLE_KEY));
            if (Role.master.equals((Object)role)) {
                if (this.currentMaster.get() != null) {
                    this.stopThreads();
                    throw new RedisException("Multiple masters detected");
                }
                this.currentMaster.set(addr);
                this.log.info("{} is the master", (Object)addr);
                this.config.setMasterAddress(addr);
                continue;
            }
            this.log.info("{} is a slave", (Object)addr);
            this.config.addSlaveAddress(addr);
        }
        if (this.currentMaster.get() == null) {
            this.stopThreads();
            throw new RedisConnectionException("Can't connect to servers!");
        }
        this.initSingleEntry();
        this.scheduleMasterChangeCheck(cfg);
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(((ReplicatedServersConfig)cfg).getDatabase());
        return res;
    }

    private void scheduleMasterChangeCheck(final ReplicatedServersConfig cfg) {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                final URI master = (URI)ReplicatedConnectionManager.this.currentMaster.get();
                ReplicatedConnectionManager.this.log.debug("Current master: {}", (Object)master);
                final AtomicInteger count = new AtomicInteger(cfg.getNodeAddresses().size());
                for (final URI addr : cfg.getNodeAddresses()) {
                    if (ReplicatedConnectionManager.this.isShuttingDown()) {
                        return;
                    }
                    RFuture<RedisConnection> connectionFuture = ReplicatedConnectionManager.this.connectToNode(cfg, addr, null, addr.getHost());
                    connectionFuture.addListener(new FutureListener<RedisConnection>(){

                        public void operationComplete(Future<RedisConnection> future) throws Exception {
                            if (!future.isSuccess()) {
                                ReplicatedConnectionManager.this.log.error(future.cause().getMessage(), future.cause());
                                if (count.decrementAndGet() == 0) {
                                    ReplicatedConnectionManager.this.scheduleMasterChangeCheck(cfg);
                                }
                                return;
                            }
                            if (ReplicatedConnectionManager.this.isShuttingDown()) {
                                return;
                            }
                            final RedisConnection connection = (RedisConnection)future.getNow();
                            RFuture result = connection.async(RedisCommands.INFO_REPLICATION, new Object[0]);
                            result.addListener(new FutureListener<Map<String, String>>(){

                                public void operationComplete(Future<Map<String, String>> future) throws Exception {
                                    if (!future.isSuccess()) {
                                        ReplicatedConnectionManager.this.log.error(future.cause().getMessage(), future.cause());
                                        ReplicatedConnectionManager.this.closeNodeConnection(connection);
                                        if (count.decrementAndGet() == 0) {
                                            ReplicatedConnectionManager.this.scheduleMasterChangeCheck(cfg);
                                        }
                                        return;
                                    }
                                    Role role = Role.valueOf((String)((Map)future.getNow()).get(ReplicatedConnectionManager.ROLE_KEY));
                                    if (Role.master.equals((Object)role)) {
                                        if (master.equals(addr)) {
                                            ReplicatedConnectionManager.this.log.debug("Current master {} unchanged", (Object)master);
                                        } else if (ReplicatedConnectionManager.this.currentMaster.compareAndSet(master, addr)) {
                                            ReplicatedConnectionManager.this.changeMaster(ReplicatedConnectionManager.this.singleSlotRange.getStartSlot(), addr);
                                        }
                                    }
                                    if (count.decrementAndGet() == 0) {
                                        ReplicatedConnectionManager.this.scheduleMasterChangeCheck(cfg);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        }, (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.monitorFuture.cancel(true);
        this.closeNodeConnections();
        super.shutdown();
    }

    private static enum Role {
        master,
        slave;

    }
}

