/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.net.InetSocketAddress;
import java.util.Map;
import org.redisson.api.ClusterNode;
import org.redisson.api.Node;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandSyncService;

public class RedisClientEntry
implements ClusterNode {
    private final RedisClient client;
    private final CommandSyncService commandExecutor;
    private final NodeType type;

    public RedisClientEntry(RedisClient client, CommandSyncService commandExecutor, NodeType type) {
        this.client = client;
        this.commandExecutor = commandExecutor;
        this.type = type;
    }

    @Override
    public NodeType getType() {
        return this.type;
    }

    public RedisClient getClient() {
        return this.client;
    }

    @Override
    public InetSocketAddress getAddr() {
        return this.client.getAddr();
    }

    @Override
    public RFuture<Boolean> pingAsync() {
        return this.commandExecutor.readAsync(this.client, null, RedisCommands.PING_BOOL, new Object[0]);
    }

    @Override
    public boolean ping() {
        return this.commandExecutor.get(this.pingAsync());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.client == null ? 0 : this.client.getAddr().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RedisClientEntry other = (RedisClientEntry)obj;
        return !(this.client == null ? other.client != null : !this.client.getAddr().equals(other.client.getAddr()));
    }

    @Override
    public RFuture<Long> timeAsync() {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.TIME, new Object[0]);
    }

    @Override
    public long time() {
        return this.commandExecutor.get(this.timeAsync());
    }

    @Override
    public RFuture<Map<String, String>> clusterInfoAsync() {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_INFO, new Object[0]);
    }

    @Override
    public Map<String, String> clusterInfo() {
        return this.commandExecutor.get(this.clusterInfoAsync());
    }

    @Override
    public Map<String, String> info(Node.InfoSection section) {
        return this.commandExecutor.get(this.infoAsync(section));
    }

    @Override
    public RFuture<Map<String, String>> infoAsync(Node.InfoSection section) {
        if (section == Node.InfoSection.ALL) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_ALL, new Object[0]);
        }
        if (section == Node.InfoSection.DEFAULT) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_DEFAULT, new Object[0]);
        }
        if (section == Node.InfoSection.SERVER) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_SERVER, new Object[0]);
        }
        if (section == Node.InfoSection.CLIENTS) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_CLIENTS, new Object[0]);
        }
        if (section == Node.InfoSection.MEMORY) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_MEMORY, new Object[0]);
        }
        if (section == Node.InfoSection.PERSISTENCE) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_PERSISTENCE, new Object[0]);
        }
        if (section == Node.InfoSection.STATS) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_STATS, new Object[0]);
        }
        if (section == Node.InfoSection.REPLICATION) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_REPLICATION, new Object[0]);
        }
        if (section == Node.InfoSection.CPU) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_CPU, new Object[0]);
        }
        if (section == Node.InfoSection.COMMANDSTATS) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_COMMANDSTATS, new Object[0]);
        }
        if (section == Node.InfoSection.CLUSTER) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_CLUSTER, new Object[0]);
        }
        if (section == Node.InfoSection.KEYSPACE) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_KEYSPACE, new Object[0]);
        }
        throw new IllegalStateException();
    }

    @Override
    public Map<String, String> info() {
        return this.clusterInfo();
    }
}

