/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;

@ChannelHandler.Sharable
public class PingConnectionHandler
extends ChannelInboundHandlerAdapter {
    private final RedisClientConfig config;

    public PingConnectionHandler(RedisClientConfig config) {
        this.config = config;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.sendPing(ctx);
        ctx.fireChannelActive();
    }

    protected void sendPing(final ChannelHandlerContext ctx) {
        Object connection = RedisConnection.getFrom(ctx.channel());
        final RFuture future = ((RedisConnection)connection).async(StringCodec.INSTANCE, RedisCommands.PING, new Object[0]);
        this.config.getTimer().newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (future.cancel(false) || !future.isSuccess()) {
                    ctx.channel().close();
                } else {
                    PingConnectionHandler.this.sendPing(ctx);
                }
            }
        }, (long)this.config.getPingConnectionInterval(), TimeUnit.MILLISECONDS);
    }
}

