/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.codec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.JsonJacksonCodec;

public class JsonJacksonMapCodec
extends JsonJacksonCodec {
    private Class<?> keyClass;
    private Class<?> valueClass;
    private TypeReference<?> keyTypeReference;
    private TypeReference<?> valueTypeReference;
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream os = new ByteBufOutputStream(out);
                JsonJacksonMapCodec.this.mapObjectMapper.writeValue((OutputStream)os, in);
                return os.buffer();
            }
            catch (IOException e) {
                out.release();
                throw e;
            }
        }
    };
    private final Decoder<Object> valueDecoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            if (JsonJacksonMapCodec.this.valueClass != null) {
                return JsonJacksonMapCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), JsonJacksonMapCodec.this.valueClass);
            }
            return JsonJacksonMapCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), JsonJacksonMapCodec.this.valueTypeReference);
        }
    };
    private final Decoder<Object> keyDecoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            if (JsonJacksonMapCodec.this.keyClass != null) {
                return JsonJacksonMapCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), JsonJacksonMapCodec.this.keyClass);
            }
            return JsonJacksonMapCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), JsonJacksonMapCodec.this.keyTypeReference);
        }
    };

    public JsonJacksonMapCodec(Class<?> keyClass, Class<?> valueClass) {
        this(null, null, keyClass, valueClass, new ObjectMapper());
    }

    public JsonJacksonMapCodec(Class<?> keyClass, Class<?> valueClass, ObjectMapper mapper) {
        this(null, null, keyClass, valueClass, mapper);
    }

    public JsonJacksonMapCodec(TypeReference<?> keyTypeReference, TypeReference<?> valueTypeReference) {
        this(keyTypeReference, valueTypeReference, null, null, new ObjectMapper());
    }

    public JsonJacksonMapCodec(TypeReference<?> keyTypeReference, TypeReference<?> valueTypeReference, ObjectMapper mapper) {
        this(keyTypeReference, valueTypeReference, null, null, mapper);
    }

    JsonJacksonMapCodec(TypeReference<?> keyTypeReference, TypeReference<?> valueTypeReference, Class<?> keyClass, Class<?> valueClass, ObjectMapper mapper) {
        super(mapper);
        this.keyTypeReference = keyTypeReference;
        this.valueTypeReference = valueTypeReference;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    @Override
    protected void initTypeInclusion(ObjectMapper mapObjectMapper) {
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.keyDecoder;
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.encoder;
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.encoder;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.valueDecoder;
    }
}

