/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class RedisConnection
implements RedisCommands {
    private static final AttributeKey<RedisConnection> CONNECTION = AttributeKey.valueOf((String)"connection");
    final RedisClient redisClient;
    private volatile RPromise<Void> fastReconnect;
    private volatile boolean closed;
    volatile Channel channel;
    private RPromise<?> connectionPromise;
    private long lastUsageTime;
    private Runnable connectedListener;
    private Runnable disconnectedListener;

    public <C> RedisConnection(RedisClient redisClient, Channel channel, RPromise<C> connectionPromise) {
        this.redisClient = redisClient;
        this.connectionPromise = connectionPromise;
        this.updateChannel(channel);
        this.lastUsageTime = System.currentTimeMillis();
    }

    protected RedisConnection(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    public void fireConnected() {
        if (this.connectedListener != null) {
            this.connectedListener.run();
        }
    }

    public void setConnectedListener(Runnable connectedListener) {
        this.connectedListener = connectedListener;
    }

    public void fireDisconnected() {
        if (this.disconnectedListener != null) {
            this.disconnectedListener.run();
        }
    }

    public void setDisconnectedListener(Runnable disconnectedListener) {
        this.disconnectedListener = disconnectedListener;
    }

    public <C extends RedisConnection> RPromise<C> getConnectionPromise() {
        return this.connectionPromise;
    }

    public static <C extends RedisConnection> C getFrom(Channel channel) {
        return (C)((RedisConnection)channel.attr(CONNECTION).get());
    }

    public CommandData getCurrentCommand() {
        QueueCommand command = (QueueCommand)this.channel.attr(CommandsQueue.CURRENT_COMMAND).get();
        if (command instanceof CommandData) {
            return (CommandData)command;
        }
        return null;
    }

    public long getLastUsageTime() {
        return this.lastUsageTime;
    }

    public void setLastUsageTime(long lastUsageTime) {
        this.lastUsageTime = lastUsageTime;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    public void updateChannel(Channel channel) {
        this.channel = channel;
        channel.attr(CONNECTION).set((Object)this);
    }

    public RedisClient getRedisClient() {
        return this.redisClient;
    }

    public <R> R await(RFuture<R> future) {
        final CountDownLatch l = new CountDownLatch(1);
        future.addListener(new FutureListener<R>(){

            public void operationComplete(Future<R> future) throws Exception {
                l.countDown();
            }
        });
        try {
            if (!l.await(this.redisClient.getCommandTimeout(), TimeUnit.MILLISECONDS)) {
                RPromise promise = (RPromise)future;
                RedisTimeoutException ex = new RedisTimeoutException("Command execution timeout for " + this.redisClient.getAddr());
                promise.tryFailure(ex);
                throw ex;
            }
            if (!future.isSuccess()) {
                if (future.cause() instanceof RedisException) {
                    throw (RedisException)future.cause();
                }
                throw new RedisException("Unexpected exception while processing command", future.cause());
            }
            return future.getNow();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public <T> T sync(RedisStrictCommand<T> command, Object ... params) {
        return (T)this.sync(null, command, params);
    }

    public <T, R> ChannelFuture send(CommandData<T, R> data) {
        return this.channel.writeAndFlush(data);
    }

    public ChannelFuture send(CommandsData data) {
        return this.channel.writeAndFlush((Object)data);
    }

    public <T, R> R sync(Codec encoder, RedisCommand<T> command, Object ... params) {
        RedissonPromise promise = new RedissonPromise();
        this.send(new CommandData(promise, encoder, command, params));
        return (R)this.await(promise);
    }

    public <T, R> RFuture<R> async(RedisCommand<T> command, Object ... params) {
        return this.async(null, command, params);
    }

    public <T, R> RFuture<R> async(long timeout, RedisCommand<T> command, Object ... params) {
        return this.async(null, command, params);
    }

    public <T, R> RFuture<R> async(Codec encoder, RedisCommand<T> command, Object ... params) {
        return this.async(-1L, encoder, command, params);
    }

    public <T, R> RFuture<R> async(long timeout, Codec encoder, RedisCommand<T> command, Object ... params) {
        final RedissonPromise promise = new RedissonPromise();
        if (timeout == -1L) {
            timeout = this.redisClient.getCommandTimeout();
        }
        if (this.redisClient.getEventLoopGroup().isShuttingDown()) {
            RedissonShutdownException cause = new RedissonShutdownException("Redisson is shutdown");
            return RedissonPromise.newFailedFuture(cause);
        }
        final ScheduledFuture scheduledFuture = this.redisClient.getEventLoopGroup().schedule(new Runnable(){

            @Override
            public void run() {
                RedisTimeoutException ex = new RedisTimeoutException("Command execution timeout for " + RedisConnection.this.redisClient.getAddr());
                promise.tryFailure(ex);
            }
        }, timeout, TimeUnit.MILLISECONDS);
        promise.addListener(new FutureListener<R>(){

            public void operationComplete(Future<R> future) throws Exception {
                scheduledFuture.cancel(false);
            }
        });
        this.send(new CommandData(promise, encoder, command, params));
        return promise;
    }

    public <T, R> CommandData<T, R> create(Codec encoder, RedisCommand<T> command, Object ... params) {
        RedissonPromise promise = new RedissonPromise();
        return new CommandData(promise, encoder, command, params);
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isFastReconnect() {
        return this.fastReconnect != null;
    }

    public void clearFastReconnect() {
        this.fastReconnect.trySuccess(null);
        this.fastReconnect = null;
    }

    public RFuture<Void> forceFastReconnectAsync() {
        RedissonPromise<Void> promise = new RedissonPromise<Void>();
        this.fastReconnect = promise;
        this.channel.close();
        return promise;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture closeAsync() {
        this.setClosed(true);
        return this.channel.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " [redisClient=" + this.redisClient + ", channel=" + this.channel + "]";
    }
}

