/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.lang.ref.ReferenceQueue;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;
import org.redisson.cache.CachedValueSoftReference;
import org.redisson.cache.ReferenceCachedValue;

public class ReferenceCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private ReferenceCachedValue.Type type;

    public static <K, V> ReferenceCacheMap<K, V> weak(long timeToLiveInMillis, long maxIdleInMillis) {
        return new ReferenceCacheMap<K, V>(timeToLiveInMillis, maxIdleInMillis, ReferenceCachedValue.Type.WEAK);
    }

    public static <K, V> ReferenceCacheMap<K, V> soft(long timeToLiveInMillis, long maxIdleInMillis) {
        return new ReferenceCacheMap<K, V>(timeToLiveInMillis, maxIdleInMillis, ReferenceCachedValue.Type.SOFT);
    }

    ReferenceCacheMap(long timeToLiveInMillis, long maxIdleInMillis, ReferenceCachedValue.Type type) {
        super(0, timeToLiveInMillis, maxIdleInMillis);
        this.type = type;
    }

    @Override
    protected CachedValue<K, V> create(K key, V value, long ttl, long maxIdleTime) {
        return new ReferenceCachedValue<K, V>(key, value, ttl, maxIdleTime, this.queue, this.type);
    }

    @Override
    protected boolean removeExpiredEntries() {
        CachedValueSoftReference value;
        while ((value = (CachedValueSoftReference)this.queue.poll()) != null) {
            this.map.remove(value.getOwner().getKey(), value.getOwner());
        }
        return super.removeExpiredEntries();
    }

    @Override
    protected void onMapFull() {
    }
}

