/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonListMultimapCache;
import org.redisson.RedissonObject;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonTopic;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RTopic;
import org.redisson.api.listener.BaseStatusListener;
import org.redisson.api.listener.MessageListener;
import org.redisson.cache.Cache;
import org.redisson.cache.CacheKey;
import org.redisson.cache.LocalCachedMapClear;
import org.redisson.cache.LocalCachedMapDisable;
import org.redisson.cache.LocalCachedMapDisableAck;
import org.redisson.cache.LocalCachedMapDisabledKey;
import org.redisson.cache.LocalCachedMapEnable;
import org.redisson.cache.LocalCachedMapInvalidate;
import org.redisson.cache.LocalCachedMapUpdate;
import org.redisson.cache.LocalCachedMessageCodec;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalCacheListener {
    public static final String TOPIC_SUFFIX = "topic";
    public static final String DISABLED_KEYS_SUFFIX = "disabled-keys";
    public static final String DISABLED_ACK_SUFFIX = ":topic";
    private Map<CacheKey, String> disabledKeys = new ConcurrentHashMap<CacheKey, String>();
    private static final Logger log = LoggerFactory.getLogger(LocalCacheListener.class);
    private String name;
    private CommandAsyncExecutor commandExecutor;
    private Cache<?, ?> cache;
    private RObject object;
    private byte[] instanceId;
    private Codec codec;
    private LocalCachedMapOptions<?, ?> options;
    private long cacheUpdateLogTime;
    private volatile long lastInvalidate;
    private RTopic<Object> invalidationTopic;
    private int syncListenerId;
    private int reconnectionListenerId;

    public LocalCacheListener(String name, CommandAsyncExecutor commandExecutor, Cache<?, ?> cache, RObject object, byte[] instanceId, Codec codec, LocalCachedMapOptions<?, ?> options, long cacheUpdateLogTime) {
        this.name = name;
        this.commandExecutor = commandExecutor;
        this.cache = cache;
        this.object = object;
        this.instanceId = instanceId;
        this.codec = codec;
        this.options = options;
        this.cacheUpdateLogTime = cacheUpdateLogTime;
    }

    public boolean isDisabled(Object key) {
        return this.disabledKeys.containsKey(key);
    }

    public void add() {
        this.invalidationTopic = new RedissonTopic<Object>(LocalCachedMessageCodec.INSTANCE, this.commandExecutor, this.getInvalidationTopicName());
        if (this.options.getReconnectionStrategy() != LocalCachedMapOptions.ReconnectionStrategy.NONE) {
            this.reconnectionListenerId = this.invalidationTopic.addListener(new BaseStatusListener(){

                @Override
                public void onSubscribe(String channel) {
                    if (LocalCacheListener.this.options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.CLEAR) {
                        LocalCacheListener.this.cache.clear();
                    }
                    if (LocalCacheListener.this.options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.LOAD && LocalCacheListener.this.lastInvalidate > 0L) {
                        if (System.currentTimeMillis() - LocalCacheListener.this.lastInvalidate > LocalCacheListener.this.cacheUpdateLogTime) {
                            LocalCacheListener.this.cache.clear();
                            return;
                        }
                        LocalCacheListener.this.object.isExistsAsync().addListener(new FutureListener<Boolean>(){

                            public void operationComplete(Future<Boolean> future) throws Exception {
                                if (!future.isSuccess()) {
                                    log.error("Can't check existance", future.cause());
                                    return;
                                }
                                if (!((Boolean)future.getNow()).booleanValue()) {
                                    LocalCacheListener.this.cache.clear();
                                    return;
                                }
                                RedissonScoredSortedSet logs = new RedissonScoredSortedSet(ByteArrayCodec.INSTANCE, LocalCacheListener.this.commandExecutor, LocalCacheListener.this.getUpdatesLogName(), null);
                                logs.valueRangeAsync(LocalCacheListener.this.lastInvalidate, true, Double.POSITIVE_INFINITY, true).addListener(new FutureListener<Collection<byte[]>>(){

                                    public void operationComplete(Future<Collection<byte[]>> future) throws Exception {
                                        if (!future.isSuccess()) {
                                            log.error("Can't load update log", future.cause());
                                            return;
                                        }
                                        for (byte[] entry : (Collection)future.getNow()) {
                                            byte[] keyHash = Arrays.copyOf(entry, 16);
                                            CacheKey key = new CacheKey(keyHash);
                                            LocalCacheListener.this.cache.remove(key);
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
        if (this.options.getSyncStrategy() != LocalCachedMapOptions.SyncStrategy.NONE) {
            this.syncListenerId = this.invalidationTopic.addListener(new MessageListener<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMessage(String channel, Object msg) {
                    LocalCachedMapInvalidate invalidateMsg;
                    Object m;
                    if (msg instanceof LocalCachedMapDisable) {
                        m = (LocalCachedMapDisable)msg;
                        String requestId = ((LocalCachedMapDisable)m).getRequestId();
                        HashSet<CacheKey> keysToDisable = new HashSet<CacheKey>();
                        for (byte[] keyHash : ((LocalCachedMapDisable)msg).getKeyHashes()) {
                            CacheKey key = new CacheKey(keyHash);
                            keysToDisable.add(key);
                        }
                        LocalCacheListener.this.disableKeys(requestId, keysToDisable, ((LocalCachedMapDisable)m).getTimeout());
                        RedissonTopic<LocalCachedMapDisableAck> topic = new RedissonTopic<LocalCachedMapDisableAck>(LocalCachedMessageCodec.INSTANCE, LocalCacheListener.this.commandExecutor, RedissonObject.suffixName(LocalCacheListener.this.name, requestId + LocalCacheListener.DISABLED_ACK_SUFFIX));
                        topic.publishAsync(new LocalCachedMapDisableAck());
                    }
                    if (msg instanceof LocalCachedMapEnable) {
                        m = (LocalCachedMapEnable)msg;
                        for (byte[] keyHash : ((LocalCachedMapEnable)m).getKeyHashes()) {
                            CacheKey key = new CacheKey(keyHash);
                            LocalCacheListener.this.disabledKeys.remove(key, ((LocalCachedMapEnable)m).getRequestId());
                        }
                    }
                    if (msg instanceof LocalCachedMapClear) {
                        LocalCacheListener.this.cache.clear();
                    }
                    if (msg instanceof LocalCachedMapInvalidate && !Arrays.equals((invalidateMsg = (LocalCachedMapInvalidate)msg).getExcludedId(), LocalCacheListener.this.instanceId)) {
                        for (Object keyHash : (Object)invalidateMsg.getKeyHashes()) {
                            CacheKey key = new CacheKey((byte[])keyHash);
                            LocalCacheListener.this.cache.remove(key);
                        }
                    }
                    if (msg instanceof LocalCachedMapUpdate) {
                        LocalCachedMapUpdate updateMsg = (LocalCachedMapUpdate)msg;
                        Object object = updateMsg.getEntries().iterator();
                        while (object.hasNext()) {
                            LocalCachedMapUpdate.Entry entry = (LocalCachedMapUpdate.Entry)object.next();
                            ByteBuf keyBuf = Unpooled.wrappedBuffer((byte[])entry.getKey());
                            ByteBuf valueBuf = Unpooled.wrappedBuffer((byte[])entry.getValue());
                            try {
                                LocalCacheListener.this.updateCache(keyBuf, valueBuf);
                            }
                            catch (IOException e) {
                                log.error("Can't decode map entry", (Throwable)e);
                            }
                            finally {
                                keyBuf.release();
                                valueBuf.release();
                            }
                        }
                    }
                    if (LocalCacheListener.this.options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.LOAD) {
                        LocalCacheListener.this.lastInvalidate = System.currentTimeMillis();
                    }
                }
            });
            String disabledKeysName = RedissonObject.suffixName(this.name, DISABLED_KEYS_SUFFIX);
            RedissonListMultimapCache multimap = new RedissonListMultimapCache(null, this.codec, this.commandExecutor, disabledKeysName);
            for (LocalCachedMapDisabledKey key : multimap.readAllKeySet()) {
                HashSet<CacheKey> keysToDisable = new HashSet<CacheKey>();
                for (String hash : multimap.getAll(key)) {
                    CacheKey cacheKey = new CacheKey(ByteBufUtil.decodeHexDump((CharSequence)hash));
                    keysToDisable.add(cacheKey);
                }
                this.disableKeys(key.getRequestId(), keysToDisable, key.getTimeout());
            }
        }
    }

    public RFuture<Void> clearLocalCacheAsync() {
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Long> future = this.invalidationTopic.publishAsync(new LocalCachedMapClear());
        future.addListener(new FutureListener<Long>(){

            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                result.trySuccess(null);
            }
        });
        return result;
    }

    public String getInvalidationTopicName() {
        return RedissonObject.suffixName(this.name, TOPIC_SUFFIX);
    }

    protected abstract void updateCache(ByteBuf var1, ByteBuf var2) throws IOException;

    private void disableKeys(final String requestId, final Set<CacheKey> keys, long timeout) {
        for (CacheKey key : keys) {
            this.disabledKeys.put(key, requestId);
            this.cache.remove(key);
        }
        this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

            @Override
            public void run() {
                for (CacheKey cacheKey : keys) {
                    LocalCacheListener.this.disabledKeys.remove(cacheKey, requestId);
                }
            }
        }, timeout, TimeUnit.MILLISECONDS);
    }

    public void remove() {
        if (this.syncListenerId != 0) {
            this.invalidationTopic.removeListener(this.syncListenerId);
        }
        if (this.reconnectionListenerId != 0) {
            this.invalidationTopic.removeListener(this.reconnectionListenerId);
        }
    }

    public String getUpdatesLogName() {
        return RedissonObject.prefixName("redisson__cache_updates_log", this.name);
    }
}

