/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonPriorityQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RPriorityBlockingQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class RedissonPriorityBlockingQueue<V>
extends RedissonPriorityQueue<V>
implements RPriorityBlockingQueue<V> {
    protected RedissonPriorityBlockingQueue(CommandExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
    }

    protected RedissonPriorityBlockingQueue(Codec codec, CommandExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public void put(V e) throws InterruptedException {
        this.add(e);
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public RFuture<V> takeAsync() {
        RedissonPromise result = new RedissonPromise();
        this.takeAsync(result, 0L, 0L, RedisCommands.LPOP, this.getName());
        return result;
    }

    protected <T> void takeAsync(final RPromise<V> result, long delay, final long timeoutInMicro, final RedisCommand<T> command, final Object ... params) {
        final long start = System.currentTimeMillis();
        this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

            @Override
            public void run() {
                RFuture future = RedissonPriorityBlockingQueue.this.pollAsync(command, params);
                future.addListener(new FutureListener<V>(){

                    public void operationComplete(Future<V> future) throws Exception {
                        if (!future.isSuccess() && !(future.cause() instanceof RedisConnectionException)) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        if (future.getNow() != null) {
                            result.trySuccess(future.getNow());
                            return;
                        }
                        if (result.isCancelled()) {
                            return;
                        }
                        long remain = 0L;
                        if (timeoutInMicro > 0L && (remain = timeoutInMicro - (System.currentTimeMillis() - start) * 1000L) <= 0L) {
                            result.trySuccess(null);
                            return;
                        }
                        long delay = PlatformDependent.threadLocalRandom().nextInt(2000000);
                        if (timeoutInMicro > 0L && remain < 2000000L) {
                            delay = 0L;
                        }
                        RedissonPriorityBlockingQueue.this.takeAsync(result, delay, remain, command, params);
                    }
                });
            }
        }, delay, TimeUnit.MICROSECONDS);
    }

    @Override
    public V take() throws InterruptedException {
        return this.get(this.takeAsync());
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        RedissonPromise result = new RedissonPromise();
        this.takeAsync(result, 0L, unit.toMicros(timeout), RedisCommands.LPOP, this.getName());
        return result;
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(this.pollAsync(timeout, unit));
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        RedissonPromise result = new RedissonPromise();
        this.takeAsync(result, 0L, unit.toMicros(timeout), RedisCommands.RPOPLPUSH, this.getName(), queueName);
        return result;
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(this.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        return this.get(this.takeLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        return this.pollLastAndOfferFirstToAsync(queueName, 0L, TimeUnit.SECONDS);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        this.lock.lock();
        try {
            int n = this.get(this.drainToAsync(c));
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('ltrim', KEYS[1], -1, 0); return vals", Collections.singletonList(this.getName()), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        this.lock.lock();
        try {
            int n = this.get(this.drainToAsync(c, maxElements));
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); return vals", Collections.singletonList(this.getName()), maxElements);
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        throw new UnsupportedOperationException("use offer method");
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        throw new UnsupportedOperationException("use add method");
    }
}

