/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.redisson.RedissonMultimap;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.HashValue;

abstract class RedissonMultiMapIterator<K, V, M>
implements Iterator<M> {
    private Map<HashValue, HashValue> firstKeys;
    private Iterator<Map.Entry<ScanObjectEntry, ScanObjectEntry>> keysIter;
    protected long keysIterPos = 0L;
    private K currentKey;
    private Iterator<V> valuesIter;
    protected long valuesIterPos = 0L;
    protected RedisClient client;
    private boolean finished;
    private boolean removeExecuted;
    protected V entry;
    final RedissonMultimap<K, V> map;
    final CommandAsyncExecutor commandExecutor;
    final Codec codec;

    public RedissonMultiMapIterator(RedissonMultimap<K, V> map, CommandAsyncExecutor commandExecutor, Codec codec) {
        this.map = map;
        this.commandExecutor = commandExecutor;
        this.codec = codec;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.valuesIter != null && this.valuesIter.hasNext()) {
            return true;
        }
        if (this.keysIter == null || !this.keysIter.hasNext()) {
            MapScanResult<ScanObjectEntry, ScanObjectEntry> res = this.map.scanIterator(this.client, this.keysIterPos);
            this.client = res.getRedisClient();
            if (this.keysIterPos == 0L && this.firstKeys == null) {
                this.firstKeys = this.convert(res.getMap());
            } else {
                Map<HashValue, HashValue> newValues = this.convert(res.getMap());
                if (newValues.equals(this.firstKeys)) {
                    this.finished = true;
                    this.firstKeys = null;
                    return false;
                }
            }
            this.keysIter = res.getMap().entrySet().iterator();
            this.keysIterPos = res.getPos();
        }
        while (this.keysIter.hasNext()) {
            Map.Entry<ScanObjectEntry, ScanObjectEntry> e = this.keysIter.next();
            this.currentKey = e.getKey().getObj();
            String name = e.getValue().getObj().toString();
            this.valuesIter = this.getIterator(name);
            if (!this.valuesIter.hasNext()) continue;
            return true;
        }
        return false;
    }

    protected abstract Iterator<V> getIterator(String var1);

    private Map<HashValue, HashValue> convert(Map<ScanObjectEntry, ScanObjectEntry> map) {
        HashMap<HashValue, HashValue> result = new HashMap<HashValue, HashValue>(map.size());
        for (Map.Entry<ScanObjectEntry, ScanObjectEntry> entry : map.entrySet()) {
            result.put(entry.getKey().getHash(), entry.getValue().getHash());
        }
        return result;
    }

    @Override
    public M next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such element at index");
        }
        this.entry = this.valuesIter.next();
        this.removeExecuted = false;
        return this.getValue(this.entry);
    }

    M getValue(V entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(this.currentKey, entry){

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void remove() {
        if (this.removeExecuted) {
            throw new IllegalStateException("Element been already deleted");
        }
        this.hasNext();
        this.keysIter.remove();
        this.map.remove(this.currentKey, this.entry);
        this.removeExecuted = true;
    }
}

