/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RBuckets;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.misc.RedissonPromise;

public class RedissonBuckets
implements RBuckets {
    private final Codec codec;
    private final CommandExecutor commandExecutor;
    private final Redisson redisson;

    public RedissonBuckets(Redisson redisson, CommandExecutor commandExecutor) {
        this(redisson, commandExecutor.getConnectionManager().getCodec(), commandExecutor);
    }

    public RedissonBuckets(Redisson redisson, Codec codec, CommandExecutor commandExecutor) {
        this.codec = codec;
        this.commandExecutor = commandExecutor;
        this.redisson = redisson;
    }

    @Override
    public <V> List<RBucket<V>> find(String pattern) {
        Iterable<String> keys = this.redisson.getKeys().getKeysByPattern(pattern);
        ArrayList<RBucket<V>> buckets = new ArrayList<RBucket<V>>();
        for (String key : keys) {
            if (key == null) continue;
            buckets.add(this.redisson.getBucket(key, this.codec));
        }
        return buckets;
    }

    @Override
    public <V> Map<String, V> get(String ... keys) {
        RFuture<Map<String, V>> future = this.getAsync(keys);
        return this.commandExecutor.get(future);
    }

    @Override
    public boolean trySet(Map<String, ?> buckets) {
        RFuture<Boolean> future = this.trySetAsync(buckets);
        return this.commandExecutor.get(future);
    }

    @Override
    public void set(Map<String, ?> buckets) {
        this.commandExecutor.get(this.setAsync(buckets));
    }

    @Override
    public <V> RFuture<Map<String, V>> getAsync(String ... keys) {
        if (keys.length == 0) {
            Map emptyMap = Collections.emptyMap();
            return RedissonPromise.newSucceededFuture(emptyMap);
        }
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("MGET", new MapGetAllDecoder(Arrays.asList(keys), 0));
        return this.commandExecutor.readAsync(keys[0], (Codec)new CompositeCodec(StringCodec.INSTANCE, this.codec, this.codec), command, (Object[])keys);
    }

    @Override
    public RFuture<Boolean> trySetAsync(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        ArrayList<String> params = new ArrayList<String>(buckets.size());
        for (Map.Entry<String, ?> entry : buckets.entrySet()) {
            params.add(entry.getKey());
            try {
                params.add((String)this.codec.getValueEncoder().encode(entry.getValue()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.commandExecutor.writeAsync(params.get(0).toString(), RedisCommands.MSETNX, params.toArray());
    }

    @Override
    public RFuture<Void> setAsync(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        ArrayList<String> params = new ArrayList<String>(buckets.size());
        for (Map.Entry<String, ?> entry : buckets.entrySet()) {
            params.add(entry.getKey());
            try {
                params.add((String)this.codec.getValueEncoder().encode(entry.getValue()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.commandExecutor.writeAsync(params.get(0).toString(), RedisCommands.MSET, params.toArray());
    }
}

