/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.MapWriterTask;
import org.redisson.command.CommandAsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapWriteBehindListener<R>
implements FutureListener<R> {
    private static final Logger log = LoggerFactory.getLogger(MapWriteBehindListener.class);
    private final AtomicInteger writeBehindCurrentThreads;
    private final Queue<Runnable> writeBehindTasks;
    private final int threadsAmount;
    private final MapWriterTask<R> task;
    private final CommandAsyncExecutor commandExecutor;

    public MapWriteBehindListener(CommandAsyncExecutor commandExecutor, MapWriterTask<R> task, AtomicInteger writeBehindCurrentThreads, Queue<Runnable> writeBehindTasks, int threadsAmount) {
        this.threadsAmount = threadsAmount;
        this.commandExecutor = commandExecutor;
        this.task = task;
        this.writeBehindCurrentThreads = writeBehindCurrentThreads;
        this.writeBehindTasks = writeBehindTasks;
    }

    public void operationComplete(Future<R> future) throws Exception {
        if (future.isSuccess() && this.task.condition(future)) {
            this.enqueueRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        MapWriteBehindListener.this.task.execute();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    private void enqueueRunnable(Runnable runnable) {
        if (runnable != null) {
            this.writeBehindTasks.add(runnable);
        }
        if (this.writeBehindCurrentThreads.incrementAndGet() <= this.threadsAmount) {
            this.commandExecutor.getConnectionManager().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Runnable runnable;
                        while ((runnable = (Runnable)MapWriteBehindListener.this.writeBehindTasks.poll()) != null) {
                            runnable.run();
                        }
                    }
                    finally {
                        if (MapWriteBehindListener.this.writeBehindCurrentThreads.decrementAndGet() == 0 && !MapWriteBehindListener.this.writeBehindTasks.isEmpty()) {
                            MapWriteBehindListener.this.enqueueRunnable(null);
                        }
                    }
                }
            });
        } else {
            this.writeBehindCurrentThreads.decrementAndGet();
        }
    }
}

