/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.extractor;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.nutz.lang.Lang;
import org.nutz.mvc.adaptor.ParamExtractor;

public class MapParamExtractor
implements ParamExtractor {
    private HttpServletRequest req;
    private Map<String, Object> map;

    public MapParamExtractor(HttpServletRequest req, Map<String, Object> refer) {
        this.req = req;
        this.map = refer;
    }

    @Override
    public String[] extractor(String name) {
        if (null != this.map && this.map.containsKey(name)) {
            Object obj = this.map.get(name);
            if (obj instanceof String[]) {
                return (String[])obj;
            }
            if (obj == null) {
                return null;
            }
            return new String[]{obj.toString()};
        }
        if (this.req == null) {
            return null;
        }
        return this.req.getParameterValues(name);
    }

    @Override
    public Set<String> keys() {
        HashSet<String> ss = new HashSet<String>();
        ss.addAll(this.map.keySet());
        if (this.req != null) {
            ss.addAll(Lang.enum2collection(this.req.getParameterNames(), new HashSet()));
        }
        return ss;
    }
}

