/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.nutz.filepool.UU32FilePool;
import org.nutz.lang.Each;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.util.NutMap;
import org.nutz.log.LogAdapter;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.upload.FastUploading;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadException;
import org.nutz.mvc.upload.UploadingContext;

public class WhaleFilter
implements Filter {
    protected Properties props = new Properties();
    protected String inputEnc;
    protected String outputEnc;
    protected String methodParam;
    protected boolean allowHTTPMethodOverride;
    protected boolean uploadEnable;
    private static WhaleFilter _me;
    protected ServletContext sc;
    protected Object uc;

    public static WhaleFilter me() {
        return _me;
    }

    public void init(FilterConfig c) throws ServletException {
        this.sc = c.getServletContext();
        _me = this;
        try {
            String path = c.getInitParameter("config-file");
            if (path != null) {
                InputStream ins = this.getClass().getClassLoader().getResourceAsStream(path);
                if (ins == null) {
                    ins = c.getServletContext().getResourceAsStream(path);
                }
                if (ins == null) {
                    throw new ServletException("config-file=" + path + " not found");
                }
                this.init(ins);
            } else {
                String config = c.getInitParameter("config");
                if (config != null) {
                    this.init(new ByteArrayInputStream(config.getBytes()));
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init(InputStream ins) throws Exception {
        this.props.load(ins);
        if (this.props.contains("log.adapter")) {
            LogAdapter la = (LogAdapter)Class.forName(this.props.getProperty("log.adapter")).newInstance();
            Logs.setAdapter(la);
        }
        this.inputEnc = this.props.getProperty("enc.input");
        this.outputEnc = this.props.getProperty("enc.output");
        this.methodParam = this.props.getProperty("http.hidden_method_param");
        this.allowHTTPMethodOverride = "true".equals(this.props.getProperty("http.method_override"));
        this.uploadEnable = "true".equals(this.props.getProperty("upload.enable"));
        if (this.uploadEnable) {
            String tmpPath = this.props.getProperty("upload.tmpdir", System.getProperty("java.io.tmpdir") + "/whale");
            UU32FilePool fp = new UU32FilePool(tmpPath);
            UploadingContext uc = new UploadingContext(fp);
            Mirror<UploadingContext> mirror = Mirror.me(uc);
            for (Object _key : this.props.keySet()) {
                String key = _key.toString();
                if (!key.startsWith("upload.") || "tmpdir".equals(key = key.substring("upload.".length())) || "exclusions".equals(key)) continue;
                mirror.setValue((Object)uc, key, this.props.get(_key));
            }
            this.uc = uc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (this.inputEnc != null) {
            req.setCharacterEncoding(this.inputEnc);
        }
        if (this.outputEnc != null) {
            resp.setCharacterEncoding(this.outputEnc);
        }
        if ("POST".equals(req.getMethod())) {
            if (this.methodParam != null) {
                String qs = req.getQueryString();
                if (qs != null && qs.contains("_method=")) {
                    final NutMap map = Mvcs.toParamMap(new StringReader(qs), this.inputEnc == null ? Charset.defaultCharset().name() : this.inputEnc);
                    request = new HttpServletRequestWrapper(req){

                        public String getMethod() {
                            return map.getString(WhaleFilter.this.methodParam);
                        }
                    };
                }
            } else if (this.allowHTTPMethodOverride && req.getHeader("X-HTTP-Method-Override") != null) {
                request = new HttpServletRequestWrapper(req){

                    public String getMethod() {
                        return req.getHeader("X-HTTP-Method-Override");
                    }
                };
            }
            String contentType = req.getContentType();
            if (contentType != null && this.uc != null && contentType.contains("multipart/form-data")) {
                request = this.handleUpload(req);
            }
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            try {
                List files = (List)req.getAttribute("_files");
                if (files != null) {
                    for (TempFile tf : files) {
                        if (tf == null) continue;
                        tf.delete();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public void destroy() {
    }

    public HttpServletRequest handleUpload(HttpServletRequest req) throws ServletException {
        try {
            FastUploading fup = new FastUploading();
            final Map<String, Object> params = fup.parse(req, (UploadingContext)this.uc);
            final ArrayList files = new ArrayList();
            Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
            while (it.hasNext()) {
                Object obj = it.next().getValue();
                final boolean[] re = new boolean[1];
                Lang.each(obj, new Each<Object>(){

                    @Override
                    public void invoke(int index, Object ele, int length) {
                        if (ele != null && ele instanceof TempFile) {
                            files.add((TempFile)ele);
                            re[0] = true;
                        }
                    }
                });
                if (!re[0]) continue;
                it.remove();
            }
            req.setAttribute("_files", files);
            params.putAll(req.getParameterMap());
            return new HttpServletRequestWrapper(req){

                public String getParameter(String name) {
                    return (String)params.get(name);
                }

                public Map getParameterMap() {
                    return params;
                }

                public Enumeration getParameterNames() {
                    return Collections.enumeration(params.keySet());
                }

                public String[] getParameterValues(String name) {
                    if (params.containsKey(name)) {
                        return new String[]{(String)params.get(name)};
                    }
                    return null;
                }
            };
        }
        catch (UploadException e) {
            throw new ServletException("upload fail", (Throwable)e);
        }
    }
}

