/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.lang.Streams;
import org.nutz.lang.util.ClassMeta;

public class ClassMetaReader {
    public static Map<String, List<String>> getParamNames(Class<?> klass) throws IOException {
        InputStream in = klass.getResourceAsStream("/" + klass.getName().replace('.', '/') + ".class");
        try {
            if (in == null) {
                HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                return hashMap;
            }
            Map<String, List<String>> map = ClassMetaReader.build((InputStream)in).paramNames;
            return map;
        }
        finally {
            Streams.safeClose(in);
        }
    }

    public static ClassMeta build(InputStream in) throws IOException {
        ClassMeta meta = new ClassMeta();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(in));
        HashMap names = new HashMap();
        HashMap<String, Integer> lines = new HashMap<String, Integer>();
        HashMap<Integer, String> strs = new HashMap<Integer, String>();
        HashMap<Integer, Integer> classIndex = new HashMap<Integer, Integer>();
        dis.skipBytes(4);
        dis.skipBytes(2);
        dis.skipBytes(2);
        int constant_pool_count = dis.readUnsignedShort();
        block12: for (int i = 0; i < constant_pool_count - 1; ++i) {
            byte flag = dis.readByte();
            switch (flag) {
                case 7: {
                    int z = dis.readUnsignedShort();
                    classIndex.put(i + 1, z);
                    continue block12;
                }
                case 9: 
                case 10: 
                case 11: {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    continue block12;
                }
                case 8: {
                    dis.skipBytes(2);
                    continue block12;
                }
                case 3: 
                case 4: {
                    dis.skipBytes(4);
                    continue block12;
                }
                case 5: 
                case 6: {
                    dis.skipBytes(8);
                    ++i;
                    continue block12;
                }
                case 12: {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    continue block12;
                }
                case 1: {
                    int len = dis.readUnsignedShort();
                    byte[] data = new byte[len];
                    dis.readFully(data);
                    strs.put(i + 1, new String(data, "UTF-8"));
                    continue block12;
                }
                case 15: {
                    dis.skipBytes(1);
                    dis.skipBytes(2);
                    continue block12;
                }
                case 16: {
                    dis.skipBytes(2);
                    continue block12;
                }
                case 18: {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Impossible!! flag=" + flag);
                }
            }
        }
        dis.skipBytes(2);
        int z = dis.readUnsignedShort();
        meta.type = (String)strs.get(classIndex.get(z));
        if (meta.type != null) {
            meta.type = meta.type.replace('/', '.');
        }
        dis.skipBytes(2);
        int interfaces_count = dis.readUnsignedShort();
        dis.skipBytes(2 * interfaces_count);
        int fields_count = dis.readUnsignedShort();
        for (int i = 0; i < fields_count; ++i) {
            dis.skipBytes(2);
            dis.skipBytes(2);
            dis.skipBytes(2);
            int attributes_count = dis.readUnsignedShort();
            for (int j = 0; j < attributes_count; ++j) {
                dis.skipBytes(2);
                int attribute_length = dis.readInt();
                dis.skipBytes(attribute_length);
            }
        }
        int methods_count = dis.readUnsignedShort();
        for (int i = 0; i < methods_count; ++i) {
            dis.skipBytes(2);
            String methodName = (String)strs.get(dis.readUnsignedShort());
            String descriptor = (String)strs.get(dis.readUnsignedShort());
            int attributes_count = dis.readShort();
            String key = methodName + "," + descriptor;
            for (int j = 0; j < attributes_count; ++j) {
                String attrName = (String)strs.get(dis.readUnsignedShort());
                int attribute_length = dis.readInt();
                if ("Code".equals(attrName)) {
                    dis.skipBytes(2);
                    dis.skipBytes(2);
                    int code_len = dis.readInt();
                    dis.skipBytes(code_len);
                    int exception_table_length = dis.readUnsignedShort();
                    dis.skipBytes(8 * exception_table_length);
                    int code_attributes_count = dis.readUnsignedShort();
                    for (int k = 0; k < code_attributes_count; ++k) {
                        int str_index = dis.readUnsignedShort();
                        String codeAttrName = (String)strs.get(str_index);
                        int code_attribute_length = dis.readInt();
                        if ("LocalVariableTable".equals(codeAttrName)) {
                            int local_variable_table_length = dis.readUnsignedShort();
                            ArrayList<String> varNames = new ArrayList<String>(local_variable_table_length);
                            for (int l = 0; l < local_variable_table_length; ++l) {
                                dis.skipBytes(2);
                                dis.skipBytes(2);
                                String varName = (String)strs.get(dis.readUnsignedShort());
                                dis.skipBytes(2);
                                dis.skipBytes(2);
                                if ("this".equals(varName)) continue;
                                varNames.add(varName);
                            }
                            if (names.containsKey(key)) continue;
                            names.put(key, varNames);
                            continue;
                        }
                        if ("LineNumberTable".equals(codeAttrName)) {
                            int len = dis.readUnsignedShort();
                            if (len <= 0) continue;
                            dis.skipBytes(2);
                            int line = dis.readUnsignedShort();
                            dis.skipBytes(code_attribute_length - 6);
                            lines.put(key, line);
                            continue;
                        }
                        dis.skipBytes(code_attribute_length);
                    }
                    continue;
                }
                if ("MethodParameters".equals(attrName)) {
                    int paramCount = dis.readByte();
                    ArrayList<String> varNames = new ArrayList<String>(paramCount);
                    for (int l = 0; l < paramCount; ++l) {
                        String varName = (String)strs.get(dis.readUnsignedShort());
                        dis.skipBytes(2);
                        if ("this".equals(varName)) continue;
                        varNames.add(varName);
                    }
                    names.put(key, varNames);
                    continue;
                }
                dis.skipBytes(attribute_length);
            }
        }
        dis.close();
        meta.paramNames.putAll(names);
        meta.methodLines.putAll(lines);
        return meta;
    }

    public static String getKey(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof Method) {
            sb.append(((Method)obj).getName()).append(',');
            ClassMetaReader.getDescriptor(sb, (Method)obj);
        } else if (obj instanceof Constructor) {
            sb.append("<init>,");
            ClassMetaReader.getDescriptor(sb, (Constructor)obj);
        } else {
            throw new RuntimeException("Not Method or Constructor!");
        }
        return sb.toString();
    }

    public static void getDescriptor(StringBuilder sb, Method method) {
        sb.append('(');
        for (Class<?> klass : method.getParameterTypes()) {
            ClassMetaReader.getDescriptor(sb, klass);
        }
        sb.append(')');
        ClassMetaReader.getDescriptor(sb, method.getReturnType());
    }

    public static void getDescriptor(StringBuilder sb, Constructor<?> constructor) {
        sb.append('(');
        for (Class<?> klass : constructor.getParameterTypes()) {
            ClassMetaReader.getDescriptor(sb, klass);
        }
        sb.append(')');
        sb.append('V');
    }

    public static void getDescriptor(StringBuilder buf, Class<?> c) {
        Class<?> d = c;
        while (true) {
            if (d.isPrimitive()) {
                int car = d == Integer.TYPE ? 73 : (d == Void.TYPE ? 86 : (d == Boolean.TYPE ? 90 : (d == Byte.TYPE ? 66 : (d == Character.TYPE ? 67 : (d == Short.TYPE ? 83 : (d == Double.TYPE ? 68 : (d == Float.TYPE ? 70 : 74)))))));
                buf.append((char)car);
                return;
            }
            if (!d.isArray()) break;
            buf.append('[');
            d = d.getComponentType();
        }
        buf.append('L');
        String name = d.getName();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char car = name.charAt(i);
            buf.append(car == '.' ? (char)'/' : (char)car);
        }
        buf.append(';');
    }
}

